/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.internal.fields;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.exception.OseeInvalidInheritanceException;
import org.eclipse.osee.framework.core.model.internal.fields.CollectionField;
import org.eclipse.osee.framework.core.model.type.ArtifactType;
import org.eclipse.osee.framework.jdk.core.type.Id;

public final class ArtifactSuperTypeField
extends CollectionField<ArtifactType> {
    private final ArtifactTypeToken baseType;

    public ArtifactSuperTypeField(ArtifactTypeToken baseType, Collection<ArtifactType> superTypes) {
        super(superTypes);
        this.baseType = baseType;
    }

    @Override
    protected Collection<ArtifactType> checkInput(Collection<ArtifactType> input) {
        Collection<ArtifactType> toReturn = Collections.emptyList();
        if (input == null || input.isEmpty()) {
            if (this.baseType.notEqual((Id)CoreArtifactTypes.Artifact)) {
                throw new OseeInvalidInheritanceException("All artifacts must inherit from [Artifact] - attempted make [%s] have null inheritance", new Object[]{this.baseType});
            }
        } else {
            if (input.contains(this.baseType)) {
                throw new OseeInvalidInheritanceException("Circular inheritance detected for artifact type [%s]", new Object[]{this.baseType});
            }
            toReturn = input;
        }
        return toReturn;
    }
}

