/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.Messages;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsEditor;
import org.eclipse.swt.widgets.Display;

public class SuppressionsReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private SuppressionsEditor editor;
    private IDocument document;
    private List<Position> positions;
    private IProgressMonitor monitor;

    public SuppressionsReconcilingStrategy(SuppressionsEditor editor) {
        this.editor = editor;
        this.positions = new ArrayList<Position>();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void initialReconcile() {
        int start = -1;
        int end = this.document.getLength();
        int worked = 0;
        this.monitor.beginTask(Messages.getString("SuppressionsReconcilingStrategy.Monitor_title"), 10);
        int pos = 0;
        while (pos < end) {
            try {
                char ch = this.document.getChar(pos);
                if (ch == '{') {
                    start = pos;
                } else if (ch == '}' && start > 0) {
                    this.positions.add(new Position(start, pos - start + 1));
                    start = -1;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (pos * 10 / end > worked) {
                this.monitor.worked(1);
                ++worked;
            }
            ++pos;
        }
        this.monitor.done();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SuppressionsReconcilingStrategy.this.editor.updateFoldingStructure(SuppressionsReconcilingStrategy.this.positions.toArray(new Position[SuppressionsReconcilingStrategy.this.positions.size()]));
            }
        });
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

