/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.latency.model;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.model.IGraphDataModel;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.model.LatencyEventRequest;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.model.LatencyGraphModel;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.ui.views.distribution.model.IBaseDistributionModel;
import org.eclipse.linuxtools.tmf.ui.views.histogram.IHistogramDataModel;

public class LatencyController {
    private static LatencyController fInstance = null;
    private LatencyEventRequest fEventRequest;
    private TmfEventProvider<?> fProvider;
    private final ListenerList fModels = new ListenerList();

    private LatencyController() {
    }

    public static LatencyController getInstance() {
        if (fInstance == null) {
            fInstance = new LatencyController();
        }
        return fInstance;
    }

    public void refreshModels(TmfEventProvider<?> provider, TmfTimeRange timeRange) {
        this.fProvider = provider;
        if (this.fProvider != null) {
            if (this.fEventRequest != null && !this.fEventRequest.isCompleted()) {
                this.fEventRequest.cancel();
            }
            this.clear();
            this.fEventRequest = new LatencyEventRequest(this, timeRange, ITmfDataRequest.ExecutionType.FOREGROUND);
            this.fProvider.sendRequest((ITmfDataRequest)this.fEventRequest);
        }
    }

    public void refreshModels() {
        if (this.fProvider != null && this.fEventRequest != null) {
            this.refreshModels(this.fProvider, this.fEventRequest.getRange());
        }
    }

    public void clear() {
        Object[] models = this.fModels.getListeners();
        int i = 0;
        while (i < models.length) {
            ((IBaseDistributionModel)models[i]).clear();
            ++i;
        }
    }

    public void dispose() {
        if (this.fEventRequest != null && !this.fEventRequest.isCompleted()) {
            this.fEventRequest.cancel();
        }
        this.fProvider = null;
    }

    public void registerModel(IBaseDistributionModel model) {
        this.fModels.add((Object)model);
    }

    public void deregisterModel(IBaseDistributionModel model) {
        this.fModels.remove((Object)model);
    }

    public void handleData(int eventCount, long timestamp, long latency) {
        Object[] models = this.fModels.getListeners();
        int i = 0;
        while (i < models.length) {
            IBaseDistributionModel model = (IBaseDistributionModel)models[i];
            if (model instanceof IHistogramDataModel) {
                ((IHistogramDataModel)model).countEvent((long)eventCount, latency);
            } else if (model instanceof IGraphDataModel) {
                ((IGraphDataModel)model).countEvent(eventCount, timestamp, latency);
            }
            ++i;
        }
    }

    public void handleCompleted() {
        Object[] models = this.fModels.getListeners();
        int i = 0;
        while (i < models.length) {
            ((IBaseDistributionModel)models[i]).complete();
            ++i;
        }
    }

    public void handleCancel() {
        this.clear();
    }

    public void setEventProvider(TmfEventProvider<?> provider) {
        this.fProvider = provider;
    }

    public void setCurrentEventTime(long timestamp) {
        Object[] models = this.fModels.getListeners();
        int i = 0;
        while (i < models.length) {
            IBaseDistributionModel model = (IBaseDistributionModel)models[i];
            if (model instanceof LatencyGraphModel) {
                ((LatencyGraphModel)model).setCurrentEventNotifyListeners(timestamp);
            }
            ++i;
        }
    }
}

