/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.latency;

import org.eclipse.linuxtools.internal.lttng.ui.views.latency.AbstractViewer;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.HistogramPaintListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.TooltipListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.ZoomListener;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramDataModel;
import org.eclipse.linuxtools.tmf.ui.views.histogram.IHistogramDataModel;
import org.eclipse.linuxtools.tmf.ui.views.histogram.IHistogramModelListener;
import org.eclipse.swt.widgets.Composite;

public class HistogramViewer
extends AbstractViewer
implements IHistogramModelListener {
    protected int fUsableWidth;
    private HistogramDataModel fModel;

    public HistogramViewer(Composite parent, int style) {
        super(parent, style);
        this.fPaintListener = new HistogramPaintListener(this);
        this.addPaintListener(this.fPaintListener);
        this.fZoomListener = new ZoomListener(this);
        this.addListener(37, this.fZoomListener);
        this.fMouseTraceListener = new TooltipListener(this, (HistogramPaintListener)this.fPaintListener);
        this.addMouseTrackListener(this.fMouseTraceListener);
        this.fModel = new HistogramDataModel();
        this.fModel.addHistogramListener((IHistogramModelListener)this);
    }

    @Override
    public void dispose() {
        this.fModel.removeHistogramListener((IHistogramModelListener)this);
        this.fPaintListener.dispose();
        super.dispose();
    }

    @Override
    public void clear() {
        this.fPaintListener.clear();
    }

    @Override
    public void clearBackground() {
        this.fPaintListener.clear();
    }

    @Override
    public void increaseBarWidth() {
        this.fPaintListener.increaseBarWitdh();
        this.modelUpdated();
    }

    @Override
    public void decreaseBarWidth() {
        this.fPaintListener.decreaseBarWitdh();
        this.modelUpdated();
    }

    public IHistogramDataModel getModel() {
        return this.fModel;
    }

    public void modelUpdated() {
        if (!this.isDisposed() && this.getDisplay() != null) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HistogramViewer.this.isDisposed()) {
                        HistogramViewer.this.redraw();
                    }
                }
            });
        }
    }
}

