/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class SelectDataSetWizardPage
extends WizardPage {
    private SelectionListener buttonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                Button target = (Button)e.widget;
                int i = 0;
                while (i < SelectDataSetWizardPage.this.btnDataSets.length) {
                    if (target == SelectDataSetWizardPage.this.btnDataSets[i]) {
                        SelectDataSetWizardPage.this.dataSetID = SelectDataSetWizardPage.this.btnDataSets[i].getData().toString();
                        SelectDataSetWizardPage.this.lblDesc.setText(String.valueOf(DataSetFactory.getName(SelectDataSetWizardPage.this.dataSetID)) + "\n\n" + DataSetFactory.getDescription(SelectDataSetWizardPage.this.dataSetID));
                        SelectDataSetWizardPage.this.wizard.getContainer().updateButtons();
                    }
                    ++i;
                }
            }
        }
    };
    private Button[] btnDataSets;
    private Label lblDesc;
    private String dataSetID;
    private DataSetWizard wizard;

    public SelectDataSetWizardPage() {
        super("selectDataSetType");
        this.setTitle(Localization.getString("SelectDataSetWizardPage.SelectDataSetType"));
        this.dataSetID = "";
        this.btnDataSets = null;
    }

    public void createControl(Composite parent) {
        this.wizard = (DataSetWizard)super.getWizard();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Composite cmpFilterOpts = new Composite(comp, 0);
        cmpFilterOpts.setLayoutData((Object)data1);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpFilterOpts.setLayout((Layout)colLayout);
        String[] ids = DataSetFactory.getIDs();
        this.btnDataSets = new Button[ids.length];
        int i = 0;
        while (i < this.btnDataSets.length) {
            this.btnDataSets[i] = new Button(cmpFilterOpts, 0);
            this.btnDataSets[i].setText(DataSetFactory.getName(ids[i]));
            this.btnDataSets[i].addSelectionListener(this.buttonListener);
            this.btnDataSets[i].setData((Object)ids[i]);
            ++i;
        }
        FormData data2 = new FormData();
        data2.left = new FormAttachment((Control)cmpFilterOpts);
        data2.top = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        this.lblDesc = new Label(comp, 64);
        this.lblDesc.setLayoutData((Object)data2);
        this.setControl((Control)comp);
    }

    public boolean canFlipToNextPage() {
        return this.dataSetID.length() > 0;
    }

    public IWizardPage getNextPage() {
        return DataSetFactory.getParsingWizardPage(this.dataSetID);
    }

    public void dispose() {
        super.dispose();
        if (this.btnDataSets != null) {
            int i = 0;
            while (i < this.btnDataSets.length) {
                this.btnDataSets[i].removeSelectionListener(this.buttonListener);
                this.btnDataSets[i].dispose();
                this.btnDataSets[i] = null;
                ++i;
            }
        }
        this.btnDataSets = null;
        this.lblDesc = null;
    }
}

