/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets;

import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.GraphCanvas;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.IGraphPrimitive;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GraphLegend
implements IGraphPrimitive {
    private final GraphCanvas graph;
    private int x;
    private int y;
    private int width;
    private int height;
    private int textHeight;
    private String[] keys;
    private Color[] colors;
    private Rectangle[] bounds;
    private static final int BORDER = 5;
    private static final int BOX_SIZE = 15;
    private static final String TITLE = Localization.getString("GraphLegend.Legend");

    public GraphLegend(GraphCanvas graph, String[] keysPassed, Color[] colorsPassed) {
        this.graph = graph;
        this.colors = colorsPassed;
        this.keys = keysPassed;
        this.bounds = new Rectangle[this.keys.length];
        this.width = 0;
        this.height = 0;
    }

    public boolean isVisible() {
        return true;
    }

    public void calculateBounds() {
        this.x = this.graph.getSize().x - this.width;
        this.y = 0;
    }

    private void getSize(GC gc) {
        this.textHeight = gc.getFontMetrics().getHeight();
        this.height = this.textHeight * (this.keys.length + 1) + 10;
        int i = 0;
        while (i < TITLE.length()) {
            this.width += gc.getCharWidth(TITLE.charAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.keys.length) {
            int currWidth = 0;
            int j = 0;
            while (j < this.keys[i2].length()) {
                currWidth += gc.getCharWidth(this.keys[i2].charAt(j));
                ++j;
            }
            if (currWidth > this.width) {
                this.width = currWidth;
            }
            ++i2;
        }
        this.width += 30;
    }

    public boolean isUnder(Point loc) {
        return loc.x >= this.x && loc.y >= this.y && loc.x <= this.x + this.width && loc.y <= this.y + this.height;
    }

    public void paint(GC gc) {
        if (this.width == 0 || this.height == 0) {
            this.getSize(gc);
        }
        this.calculateBounds();
        Color temp = gc.getForeground();
        gc.setForeground(this.graph.axisColor);
        gc.drawRectangle(this.x, this.y, this.width, this.height);
        gc.fillRectangle(this.x + 1, this.y + 1, this.width - 1, this.height - 1);
        gc.drawText(TITLE, this.x + 5, this.y + 5);
        int i = 0;
        while (i < this.keys.length) {
            gc.setForeground(this.colors[i]);
            this.bounds[i] = new Rectangle(this.x + 5, this.y + 5 + (i + 1) * this.textHeight, 15, 15);
            gc.fillGradientRectangle(this.bounds[i].x, this.bounds[i].y, 15, 15, true);
            gc.setForeground(this.graph.axisColor);
            gc.drawText(this.keys[i], this.x + 10 + 15, this.bounds[i].y);
            ++i;
        }
        gc.setForeground(temp);
    }
}

