/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.GraphingAPIUIPlugin;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.ISeries;
import org.swtchart.ITitle;
import org.swtchart.LineStyle;

public abstract class AbstractChartWithAxisBuilder
extends AbstractChartBuilder {
    protected String xTitle = null;
    protected boolean xLineGrid;
    protected boolean yLineGrid;

    public AbstractChartWithAxisBuilder(IAdapter adapter, Composite parent, int style, String title) {
        super(adapter, parent, style, title);
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        this.xLineGrid = store.getBoolean("ShowXGridLines");
        this.yLineGrid = store.getBoolean("ShowYGridLines");
    }

    protected void buildXAxis() {
        super.buildXAxis();
        String[] labels = this.adapter.getLabels();
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        if (this.xLineGrid) {
            xAxis.getGrid().setStyle(LineStyle.SOLID);
        } else {
            xAxis.getGrid().setStyle(LineStyle.NONE);
        }
        xAxis.getTick().setForeground(BLACK);
        ITitle xTitle = xAxis.getTitle();
        xTitle.setForeground(BLACK);
        if (labels.length > 0) {
            xTitle.setText(labels[0]);
        } else {
            xTitle.setText("");
        }
    }

    protected void buildYAxis() {
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setText("");
        if (this.yLineGrid) {
            yAxis.getGrid().setStyle(LineStyle.SOLID);
        } else {
            yAxis.getGrid().setStyle(LineStyle.NONE);
        }
        yAxis.getTick().setForeground(BLACK);
    }

    protected void buildXSeries() {
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0) {
            return;
        }
        int totalMaxItems = (int)Math.round((double)this.maxItems * this.scale);
        int start = 0;
        int len = Math.min(totalMaxItems, data.length);
        if (totalMaxItems < data.length) {
            start = data.length - totalMaxItems;
        }
        double[] valx = new double[len];
        double[][] valy = new double[data[0].length - 1][len];
        ISeries[] allSeries = this.chart.getSeriesSet().getSeries();
        int i = 0;
        while (i < valx.length) {
            int j = 0;
            while (j < data[start + i].length) {
                if (j == 0) {
                    valx[i] = this.getDoubleValue(data[start + i][j]);
                } else {
                    valy[j - 1][i] = this.getDoubleValue(data[start + i][j]);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < valy.length) {
            ISeries series = i >= allSeries.length ? this.createChartISeries(i) : this.chart.getSeriesSet().getSeries()[i];
            series.setXSeries(valx);
            series.setYSeries(valy[i]);
            ++i;
        }
        this.chart.getAxisSet().adjustRange();
        this.chart.redraw();
    }

    protected ISeries createChartISeries(int i) {
        return null;
    }
}

