/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationDelegate;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;

public class PerfLaunchConfigDelegate
extends ProfileLaunchConfigurationDelegate {
    protected String getPluginID() {
        return "org.eclipse.linuxtools.perf";
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!PerfCore.checkPerfInPath()) {
            Status status = new Status(4, "org.eclipse.linuxtools.perf", "Error: Perf was not found on PATH");
            throw new CoreException((IStatus)status);
        }
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        File wd = this.getWorkingDirectory(config);
        if (wd == null) {
            wd = new File(System.getProperty("user.home", "."));
        }
        String[] arguments = this.getProgramArgumentsArray(config);
        ArrayList<String> command = new ArrayList<String>(4 + arguments.length);
        command.addAll(Arrays.asList(PerfCore.getRecordString(config)));
        command.add(exePath.toOSString());
        command.addAll(Arrays.asList(arguments));
        String[] commandArray = command.toArray(new String[command.size()]);
        boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
        try {
            Process process = this.execute(commandArray, this.getEnvironment(config), wd, usePty);
            this.createNewProcess(launch, process, commandArray[0]);
            process.waitFor();
            PrintStream print = null;
            if (config.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true)) {
                ConsolePlugin plugin = ConsolePlugin.getDefault();
                IConsoleManager conMan = plugin.getConsoleManager();
                IConsole[] existing = conMan.getConsoles();
                IOConsole binaryOutCons = null;
                IConsole[] iConsoleArray = existing;
                int n = existing.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole x = iConsoleArray[n2];
                    if (x.getName().contains(this.renderProcessLabel(commandArray[0]))) {
                        binaryOutCons = (IOConsole)x;
                    }
                    ++n2;
                }
                if (binaryOutCons == null && existing.length != 0 && existing[existing.length - 1] instanceof IOConsole) {
                    binaryOutCons = (IOConsole)existing[existing.length - 1];
                }
                PrintStream outputTo = binaryOutCons != null ? binaryOutCons.newOutputStream() : System.out;
                print = new PrintStream(outputTo);
                int i = 0;
                while (i < commandArray.length) {
                    print.print(String.valueOf(commandArray[i]) + " ");
                    ++i;
                }
                print.println();
                print.println("Analysing recorded perf.data, please wait...");
            }
            PerfCore.Report(config, this.getEnvironment(config), wd, monitor, null, print);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String generateCommand(ILaunchConfiguration config) {
        return null;
    }
}

