/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.parser;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileErrorHandler;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileTaskHandler;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Messages;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParseException;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePatchMacro;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSection;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSource;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileTag;

public class SpecfileParser {
    private static final String DEFINE_SEPARATOR = ":";
    private static final String SPACE_REGEX = "\\s+";
    public static final String[] simpleSections = new String[]{"%prep", "%build", "%install", "%clean", "%changelog"};
    private static String[] complexSections = new String[]{"%pretrans", "%pre", "%preun", "%post", "%postun", "%posttrans", "%files", "%package", "%description"};
    private static String[] simpleDefinitions = new String[]{"Epoch", "Name", "Version", "Release", "URL", "BuildArch"};
    private static String[] directValuesDefinitions = new String[]{"License", "BuildRoot"};
    private static String[] complexDefinitions = new String[]{"Source", "Patch"};
    private static String[] packageLevelDefinitions = new String[]{"Summary", "Group", "Obsoletes", "Provides", "Requires", "Requires(pre)", "Requires(post)", "Requires(postun)"};
    private SpecfileErrorHandler errorHandler;
    private SpecfileTaskHandler taskHandler;
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private SpecfileSection lastSection;
    private SpecfilePackage activePackage;

    public Specfile parse(IDocument specfileDocument) {
        if (this.errorHandler != null) {
            this.errorHandler.removeExistingMarkers();
        }
        if (this.taskHandler != null) {
            this.taskHandler.removeExistingMarkers();
        }
        LineNumberReader reader = new LineNumberReader(new StringReader(specfileDocument.get()));
        String line = "";
        int lineStartPosition = 0;
        Specfile specfile = new Specfile();
        specfile.setDocument(specfileDocument);
        try {
            while ((line = reader.readLine()) != null) {
                SpecfileElement element;
                if (this.taskHandler != null) {
                    this.generateTaskMarker(reader.getLineNumber() - 1, line);
                }
                if ((element = this.parseLine(line, specfile, reader.getLineNumber() - 1)) != null) {
                    element.setLineNumber(reader.getLineNumber() - 1);
                    element.setLineStartPosition(lineStartPosition);
                    element.setLineEndPosition(lineStartPosition + line.length());
                    if (element.getClass() == SpecfileTag.class) {
                        SpecfileTag tag = (SpecfileTag)element;
                        specfile.addDefine(tag);
                    } else if (element.getClass() == SpecfilePatchMacro.class) {
                        SpecfileSource thisPatch;
                        SpecfilePatchMacro thisPatchMacro = (SpecfilePatchMacro)element;
                        if (thisPatchMacro != null) {
                            thisPatchMacro.setSpecfile(specfile);
                        }
                        if ((thisPatch = specfile.getPatch(thisPatchMacro.getPatchNumber())) != null) {
                            thisPatch.addLineUsed(reader.getLineNumber() - 1);
                            thisPatch.setSpecfile(specfile);
                        }
                    } else if (element.getClass() == SpecfileDefine.class) {
                        specfile.addDefine((SpecfileDefine)element);
                    } else if (element.getClass() == SpecfileSource.class) {
                        SpecfileSource source = (SpecfileSource)element;
                        source.setLineNumber(reader.getLineNumber() - 1);
                        if (source.getSourceType() == SpecfileSource.SourceType.SOURCE) {
                            specfile.addSource(source);
                        } else {
                            specfile.addPatch(source);
                        }
                    }
                }
                lineStartPosition += line.length() + 1;
            }
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
        }
        return specfile;
    }

    private void generateTaskMarker(int lineNumber, String line) {
        String[] taskTags = this.store.getString("RpmSpecTaskTags").split(";");
        int commentCharIndex = line.indexOf("#");
        if (commentCharIndex > -1) {
            String[] stringArray = taskTags;
            int n = taskTags.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                int taskIndex = line.indexOf(item);
                if (taskIndex > commentCharIndex) {
                    this.taskHandler.handleTask(lineNumber, line, item);
                }
                ++n2;
            }
        }
    }

    public Specfile parse(String specfileContent) {
        return this.parse((IDocument)new Document(specfileContent));
    }

    public SpecfileElement parseLine(String lineText, Specfile specfile, int lineNumber) {
        String directValuesDefinition;
        if (lineText.startsWith("%")) {
            return this.parseMacro(lineText, specfile, lineNumber);
        }
        String[] stringArray = simpleDefinitions;
        int n = simpleDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            String simpleDefinition = stringArray[n2];
            if (lineText.startsWith(String.valueOf(simpleDefinition) + DEFINE_SEPARATOR)) {
                return this.parseSimpleDefinition(lineText, specfile, lineNumber, false);
            }
            ++n2;
        }
        stringArray = directValuesDefinitions;
        n = directValuesDefinitions.length;
        n2 = 0;
        while (n2 < n) {
            directValuesDefinition = stringArray[n2];
            if (lineText.startsWith(String.valueOf(directValuesDefinition) + DEFINE_SEPARATOR)) {
                return this.parseDirectDefinition(lineText, specfile, lineNumber);
            }
            ++n2;
        }
        stringArray = packageLevelDefinitions;
        n = packageLevelDefinitions.length;
        n2 = 0;
        while (n2 < n) {
            directValuesDefinition = stringArray[n2];
            if (lineText.startsWith(String.valueOf(directValuesDefinition) + DEFINE_SEPARATOR)) {
                SpecfileElement definition = this.parseDirectDefinition(lineText, specfile, lineNumber);
                if (directValuesDefinition.equals("Requires")) {
                    if (this.activePackage != null) {
                        this.activePackage.addRequire((SpecfileTag)definition);
                    } else {
                        specfile.addRequire((SpecfileTag)definition);
                    }
                }
                return definition;
            }
            ++n2;
        }
        if (lineText.startsWith(complexDefinitions[0]) && lineText.contains(DEFINE_SEPARATOR)) {
            return this.parseComplexDefinition(lineText, lineNumber, SpecfileSource.SourceType.SOURCE);
        }
        if (lineText.startsWith(complexDefinitions[1]) && lineText.contains(DEFINE_SEPARATOR)) {
            return this.parseComplexDefinition(lineText, lineNumber, SpecfileSource.SourceType.PATCH);
        }
        if (lineText.startsWith("BuildRequires")) {
            return this.parseBuildRequire(lineText, lineNumber, specfile);
        }
        return null;
    }

    private SpecfileElement parseBuildRequire(String lineText, int lineNumber, Specfile specfile) {
        String value = lineText.substring(lineText.indexOf(58) + 1, lineText.length()).trim();
        SpecfileDefine buildRequire = new SpecfileDefine("BuildRequires", value, specfile, null);
        buildRequire.setLineNumber(lineNumber);
        specfile.addBuildRequire(buildRequire);
        return buildRequire;
    }

    private SpecfileSection parseSection(String lineText, Specfile specfile, int lineNumber) {
        List<String> tokens = Arrays.asList(lineText.split(SPACE_REGEX));
        SpecfileSection toReturn = null;
        boolean isSimpleSection = false;
        Iterator<String> iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            String[] stringArray = simpleSections;
            int n = simpleSections.length;
            int n2 = 0;
            while (n2 < n) {
                String simpleSection = stringArray[n2];
                if (token.equals(simpleSection)) {
                    toReturn = new SpecfileSection(token.substring(1), specfile);
                    specfile.addSection(toReturn);
                    isSimpleSection = true;
                }
                ++n2;
            }
            stringArray = complexSections;
            n = complexSections.length;
            n2 = 0;
            while (n2 < n) {
                String complexSection = stringArray[n2];
                if (token.equals(complexSection)) {
                    String name = token.substring(1);
                    if (!name.equals("package")) {
                        toReturn = new SpecfileSection(name, specfile);
                        specfile.addComplexSection(toReturn);
                    }
                    while (iter.hasNext()) {
                        String nextToken = iter.next();
                        if (nextToken.equals("-n")) {
                            if (!iter.hasNext()) {
                                this.errorHandler.handleError(new SpecfileParseException(String.valueOf(Messages.getString("SpecfileParser.1")) + name + Messages.getString("SpecfileParser.2"), lineNumber, 0, lineText.length(), 2));
                                continue;
                            }
                            nextToken = iter.next();
                            if (nextToken.startsWith("-")) {
                                this.errorHandler.handleError(new SpecfileParseException(String.valueOf(Messages.getString("SpecfileParser.3")) + nextToken + Messages.getString("SpecfileParser.4"), lineNumber, 0, lineText.length(), 2));
                            }
                        } else if (nextToken.equals("-p") || nextToken.equals("-f")) break;
                        if (toReturn == null) {
                            SpecfilePackage tmpPackage = specfile.getPackage(nextToken);
                            if (tmpPackage == null) {
                                tmpPackage = new SpecfilePackage(nextToken, specfile);
                                specfile.addPackage(tmpPackage);
                            }
                            this.activePackage = tmpPackage;
                            return tmpPackage;
                        }
                        SpecfilePackage enclosingPackage = specfile.getPackage(nextToken);
                        if (enclosingPackage == null) {
                            enclosingPackage = new SpecfilePackage(nextToken, specfile);
                            specfile.addPackage(enclosingPackage);
                        }
                        toReturn.setPackage(enclosingPackage);
                        enclosingPackage.addSection(toReturn);
                    }
                }
                ++n2;
            }
        }
        if (toReturn != null && toReturn.getPackage() == null) {
            SpecfilePackage topPackage = specfile.getPackage(specfile.getName());
            if (topPackage == null) {
                topPackage = new SpecfilePackage(specfile.getName(), specfile);
                specfile.addPackage(topPackage);
            }
            if (!isSimpleSection) {
                topPackage.addSection(toReturn);
            }
        }
        if (this.lastSection != null) {
            this.lastSection.setSectionEndLine(lineNumber);
        }
        return toReturn;
    }

    private SpecfileElement parseMacro(String lineText, Specfile specfile, int lineNumber) {
        if (lineText.startsWith("%define") || lineText.startsWith("%global")) {
            return this.parseDefine(lineText, specfile, lineNumber);
        }
        if (lineText.startsWith("%patch")) {
            return this.parsePatch(lineText, lineNumber);
        }
        String[] sections = new String[simpleSections.length + complexSections.length];
        System.arraycopy(simpleSections, 0, sections, 0, simpleSections.length);
        System.arraycopy(complexSections, 0, sections, simpleSections.length, complexSections.length);
        String[] stringArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            String section = stringArray[n2];
            if (lineText.startsWith(section)) {
                this.lastSection = this.parseSection(lineText, specfile, lineNumber);
                if (this.lastSection != null) {
                    this.lastSection.setSectionEndLine(lineNumber + 1);
                }
                return this.lastSection;
            }
            ++n2;
        }
        return null;
    }

    private SpecfileElement parsePatch(String lineText, int lineNumber) {
        SpecfilePatchMacro toReturn = null;
        List<String> tokens = Arrays.asList(lineText.split(SPACE_REGEX));
        for (String token : tokens) {
            try {
                if (!token.startsWith("%patch")) continue;
                int patchNumber = 0;
                if (token.length() > 6) {
                    patchNumber = Integer.parseInt(token.substring(6));
                }
                toReturn = new SpecfilePatchMacro(patchNumber);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorHandler.handleError(new SpecfileParseException(Messages.getString("SpecfileParser.5"), lineNumber, 0, lineText.length(), 2));
                return null;
            }
        }
        return toReturn;
    }

    private SpecfileDefine parseDefine(String lineText, Specfile specfile, int lineNumber) {
        List<String> tokens = Arrays.asList(lineText.split(SPACE_REGEX));
        SpecfileDefine toReturn = null;
        Iterator<String> iter = tokens.iterator();
        while (iter.hasNext()) {
            iter.next();
            while (iter.hasNext()) {
                String defineName = iter.next();
                if (!Character.isLetter(defineName.charAt(0)) && defineName.charAt(0) != '_') {
                    this.errorHandler.handleError(new SpecfileParseException(Messages.getString("SpecfileParser.6"), lineNumber, 0, lineText.length(), 2));
                    return null;
                }
                if (iter.hasNext()) {
                    String defineStringValue = iter.next();
                    if (iter.hasNext()) {
                        defineStringValue = lineText.substring(lineText.indexOf(defineStringValue));
                        while (iter.hasNext()) {
                            iter.next();
                        }
                    }
                    int defineIntValue = -1;
                    try {
                        defineIntValue = Integer.parseInt(defineStringValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        toReturn = new SpecfileDefine(defineName, defineStringValue, specfile, null);
                    }
                    if (toReturn != null) continue;
                    toReturn = new SpecfileDefine(defineName, defineIntValue, specfile, null);
                    continue;
                }
                this.errorHandler.handleError(new SpecfileParseException(String.valueOf(defineName) + Messages.getString("SpecfileParser.14"), lineNumber, 0, lineText.length(), 2));
            }
        }
        return toReturn;
    }

    private SpecfileElement parseComplexDefinition(String lineText, int lineNumber, SpecfileSource.SourceType sourceType) {
        SpecfileSource toReturn = null;
        List<String> tokens = Arrays.asList(lineText.split(SPACE_REGEX));
        int number = -1;
        boolean firstToken = true;
        Iterator<String> iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            if (token == null || token.length() <= 0) continue;
            if (firstToken) {
                if (!token.endsWith(DEFINE_SEPARATOR)) {
                    this.errorHandler.handleError(new SpecfileParseException(Messages.getString("SpecfileParser.8"), lineNumber, 0, lineText.length(), 1));
                    return null;
                }
                token = token.substring(0, token.length() - 1);
                if (sourceType == SpecfileSource.SourceType.PATCH) {
                    if (token.length() > 5) {
                        number = Integer.parseInt(token.substring(5));
                        if (!("patch" + number).equalsIgnoreCase(token)) {
                            this.errorHandler.handleError(new SpecfileParseException(Messages.getString("SpecfileParser.10"), lineNumber, 0, lineText.length(), 2));
                            return null;
                        }
                    } else {
                        number = 0;
                    }
                } else if (token.length() > 6) {
                    number = Integer.parseInt(token.substring(6));
                    if (!("source" + number).equalsIgnoreCase(token)) {
                        this.errorHandler.handleError(new SpecfileParseException(Messages.getString("SpecfileParser.11"), lineNumber, 0, lineText.length(), 2));
                        return null;
                    }
                } else {
                    number = 0;
                }
                toReturn = new SpecfileSource(number, "");
                toReturn.setSourceType(sourceType);
                firstToken = false;
                continue;
            }
            if (toReturn != null) {
                toReturn.setFileName(token);
            }
            if (!iter.hasNext()) continue;
            this.errorHandler.handleError(new SpecfileParseException(Messages.getString("SpecfileParser.12"), lineNumber, 0, lineText.length(), 2));
        }
        return toReturn;
    }

    private SpecfileElement parseSimpleDefinition(String lineText, Specfile specfile, int lineNumber, boolean warnMultipleValues) {
        SpecfileTag toReturn;
        block6: {
            List<String> tokens = Arrays.asList(lineText.split(SPACE_REGEX));
            toReturn = null;
            Iterator<String> iter = tokens.iterator();
            while (iter.hasNext()) {
                String token = iter.next();
                if (token.length() <= 0) break;
                if (iter.hasNext()) {
                    String possValue = iter.next();
                    if (possValue.startsWith("%") && iter.hasNext()) {
                        possValue = String.valueOf(possValue) + ' ' + iter.next();
                    }
                    toReturn = new SpecfileTag(token.substring(0, token.length() - 1).toLowerCase(), possValue, specfile, null);
                    if (!iter.hasNext() || warnMultipleValues) continue;
                    this.errorHandler.handleError(new SpecfileParseException(String.valueOf(token.substring(0, token.length() - 1)) + Messages.getString("SpecfileParser.13"), lineNumber, 0, lineText.length(), 2));
                    return null;
                }
                this.errorHandler.handleError(new SpecfileParseException(String.valueOf(token.substring(0, token.length() - 1)) + Messages.getString("SpecfileParser.14"), lineNumber, 0, lineText.length(), 2));
                toReturn = null;
            }
            if (toReturn != null && toReturn.getStringValue() != null) {
                try {
                    int intValue = Integer.parseInt(toReturn.getStringValue());
                    toReturn.setValue(intValue);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!toReturn.getName().equalsIgnoreCase("Epoch")) break block6;
                    this.errorHandler.handleError(new SpecfileParseException(Messages.getString("SpecfileParser.16"), lineNumber, 0, lineText.length(), 2));
                    toReturn = null;
                }
            }
        }
        return toReturn;
    }

    private SpecfileElement parseDirectDefinition(String lineText, Specfile specfile, int lineNumber) {
        SpecfileTag directDefinition;
        String[] parts = lineText.split(DEFINE_SEPARATOR, 2);
        if (parts.length == 2) {
            directDefinition = new SpecfileTag(parts[0], parts[1].trim(), specfile, this.activePackage);
            directDefinition.setLineNumber(lineNumber);
        } else {
            this.errorHandler.handleError(new SpecfileParseException(String.valueOf(parts[0]) + Messages.getString("SpecfileParser.14"), lineNumber, 0, lineText.length(), 2));
            directDefinition = null;
        }
        return directDefinition;
    }

    public void setErrorHandler(SpecfileErrorHandler specfileErrorHandler) {
        this.errorHandler = specfileErrorHandler;
    }

    public void setTaskHandler(SpecfileTaskHandler specfileTaskHandler) {
        this.taskHandler = specfileTaskHandler;
    }
}

