/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.callgraph;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.callgraph.Messages;
import org.eclipse.linuxtools.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StapGraphParser
extends SystemTapParser {
    public HashMap<Integer, Long> timeMap;
    public TreeMap<Integer, String> serialMap;
    public HashMap<Integer, HashMap<Integer, ArrayList<Integer>>> neighbourMaps;
    public HashMap<String, Long> aggregateTimeMap;
    public HashMap<String, Integer> countMap;
    public ArrayList<Integer> callOrderList;
    public HashMap<Integer, String> markedMap;
    public String markedNodes;
    public int validator;
    public Long endingTimeInNS;
    public long totalTime;
    public HashMap<Integer, Integer> lastFunctionMap;
    public ICProject project;
    private static final String DELIM = ",,";
    private boolean encounteredMain = false;
    private ArrayList<Integer> shouldGetEndingTimeForID = new ArrayList();
    private HashMap<Integer, ArrayList<String>> nameMaps;
    private HashMap<Integer, ArrayList<Integer>> idMaps;
    private boolean skippedDirectives = false;
    private int firstNode = -1;
    public long startTime = -1L;
    public String text;

    protected void initialize() {
        this.neighbourMaps = new HashMap();
        this.timeMap = new HashMap();
        this.serialMap = new TreeMap();
        this.aggregateTimeMap = new HashMap();
        this.countMap = new HashMap();
        this.endingTimeInNS = 0L;
        this.callOrderList = new ArrayList();
        this.markedMap = new HashMap();
        this.lastFunctionMap = new HashMap();
        this.nameMaps = new HashMap();
        this.idMaps = new HashMap();
        this.project = null;
        this.startTime = -1L;
    }

    public IStatus nonRealTimeParsing() {
        this.neighbourMaps.clear();
        this.timeMap.clear();
        this.serialMap.clear();
        this.aggregateTimeMap.clear();
        this.countMap.clear();
        this.text = "";
        this.callOrderList.clear();
        this.shouldGetEndingTimeForID.clear();
        this.nameMaps.clear();
        this.idMaps.clear();
        this.encounteredMain = false;
        this.skippedDirectives = false;
        this.firstNode = -1;
        this.startTime = -1L;
        BufferedReader buff = null;
        try {
            buff = new BufferedReader(new FileReader(this.sourcePath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)new Shell(), (String)Messages.getString("StapGraphParser.FileNotFound"), (String)(String.valueOf(Messages.getString("StapGraphParser.CouldNotOpen")) + StapGraphParser.this.sourcePath));
                }
            });
            return Status.CANCEL_STATUS;
        }
        this.internalData = buff;
        return this.realTimeParsing();
    }

    private void parseEnd() {
        boolean timeCheck;
        for (int key : this.idMaps.keySet()) {
            ArrayList<Integer> idList = this.idMaps.get(key);
            int lastFunctionCalled = this.lastFunctionMap.get(key);
            if (idList.size() <= 1) continue;
            for (int val : idList) {
                String name = this.serialMap.get(val);
                long time = this.endingTimeInNS - this.timeMap.get(val);
                this.timeMap.put(val, time);
                if (val == this.firstNode) {
                    this.showTime(val, time);
                }
                if (this.shouldGetEndingTimeForID.contains(val)) {
                    long cumulativeTime = this.aggregateTimeMap.get(name) + this.endingTimeInNS;
                    this.aggregateTimeMap.put(name, cumulativeTime);
                }
                lastFunctionCalled = val;
            }
            String tmp = this.markedMap.get(lastFunctionCalled);
            if (tmp == null) {
                tmp = "";
            }
            this.markedMap.put(lastFunctionCalled, String.valueOf(tmp) + "\n" + Messages.getString("StapGraphParser.Term"));
        }
        boolean bl = timeCheck = this.totalTime < 50000000L && ((double)((float)this.timeMap.get(this.firstNode).longValue() / (float)this.totalTime) > 1.01 || (double)((float)this.timeMap.get(this.firstNode).longValue() / (float)this.totalTime) < 0.99);
        if (this.skippedDirectives || timeCheck) {
            this.totalTime = this.timeMap.get(this.firstNode);
            String markedMessage = "";
            if (this.markedMap.containsKey(this.firstNode)) {
                markedMessage = String.valueOf(this.markedMap.get(this.firstNode)) + "\n";
            }
            if (this.skippedDirectives) {
                markedMessage = String.valueOf(markedMessage) + Messages.getString("StapGraphParser.CDirectives");
            }
            if (timeCheck) {
                markedMessage = String.valueOf(markedMessage) + Messages.getString("StapGraphParser.TooFast");
            }
            markedMessage = String.valueOf(markedMessage) + Messages.getString("StapGraphParser.TimeForThisNode");
            this.markedMap.put(this.firstNode, markedMessage);
        }
    }

    private void parseMarked(String msg) {
        String[] parsed = msg.split(DELIM, 2);
        int key = Integer.parseInt(parsed[0]);
        ArrayList<Integer> idList = this.idMaps.get(key);
        if (idList == null || msg.length() < 1 || idList.size() < 1) {
            return;
        }
        int id = idList.get(idList.size() - 1);
        if (parsed[1].equals("<unknown>")) {
            parsed[1] = String.valueOf(parsed[1]) + Messages.getString("StapGraphParser.UnknownMarkers");
        }
        this.markedMap.put(id, String.valueOf(this.markedMap.get(id) == null ? "" : this.markedMap.get(id)) + parsed[1]);
    }

    private IStatus parse(String s) {
        try {
            if (s.length() < 1) {
                return Status.OK_STATUS;
            }
            switch (s.charAt(0)) {
                case '<': {
                    String[] args = s.substring(1, s.length()).split(DELIM);
                    int id = Integer.parseInt(args[1]);
                    long time = Long.parseLong(args[2]);
                    int tid = Integer.parseInt(args[3]);
                    String name = args[0];
                    if (!this.encounteredMain && !this.isFunctionNameClean(name) && name.contains("__")) {
                        this.skippedDirectives = true;
                    } else {
                        HashMap<Integer, ArrayList<Integer>> outNeighbours;
                        ArrayList<Integer> idList;
                        ArrayList<String> nameList = this.nameMaps.get(tid);
                        if (nameList == null) {
                            nameList = new ArrayList();
                        }
                        if ((idList = this.idMaps.get(tid)) == null) {
                            idList = new ArrayList();
                        }
                        if ((outNeighbours = this.neighbourMaps.get(tid)) == null) {
                            outNeighbours = new HashMap();
                        }
                        if (this.startTime < 1L) {
                            this.startTime = time;
                        }
                        this.endingTimeInNS = time;
                        if ((name = this.cleanFunctionName(name)).equals("main")) {
                            this.encounteredMain = true;
                        }
                        if (this.firstNode == -1) {
                            this.firstNode = id;
                        }
                        this.serialMap.put(id, name);
                        this.timeMap.put(id, time);
                        if (this.aggregateTimeMap.get(name) == null) {
                            this.aggregateTimeMap.put(name, 0L);
                        }
                        if (nameList.indexOf(name) == -1) {
                            long cumulativeTime = this.aggregateTimeMap.get(name) - time;
                            this.aggregateTimeMap.put(name, cumulativeTime);
                            this.shouldGetEndingTimeForID.add(id);
                        }
                        if (this.countMap.get(name) == null) {
                            this.countMap.put(name, 0);
                        }
                        this.countMap.put(name, this.countMap.get(name) + 1);
                        nameList.add(name);
                        idList.add(id);
                        if (outNeighbours.get(id) == null) {
                            outNeighbours.put(id, new ArrayList());
                        }
                        if (idList.size() > 1) {
                            int parentID = idList.get(idList.size() - 2);
                            outNeighbours.get(parentID).add(id);
                        }
                        this.callOrderList.add(id);
                        this.lastFunctionMap.put(tid, id);
                        this.neighbourMaps.put(tid, outNeighbours);
                        this.nameMaps.put(tid, nameList);
                        this.idMaps.put(tid, idList);
                    }
                    break;
                }
                case '>': {
                    ArrayList<Integer> idList;
                    String[] args = s.substring(1, s.length()).split(DELIM);
                    String name = args[0];
                    int tid = Integer.parseInt(args[2]);
                    ArrayList<String> nameList = this.nameMaps.get(tid);
                    if (nameList == null) {
                        nameList = new ArrayList();
                    }
                    if ((idList = this.idMaps.get(tid)) == null) {
                        idList = new ArrayList();
                    }
                    if (!this.encounteredMain && !this.isFunctionNameClean(name) && name.contains("__")) {
                        this.skippedDirectives = true;
                    } else {
                        int lastOccurance = nameList.lastIndexOf(name = this.cleanFunctionName(name));
                        if (lastOccurance < 0) {
                            this.parsingError(String.valueOf(Messages.getString("StapGraphParser.RetMismatch")) + name);
                            return Status.CANCEL_STATUS;
                        }
                        nameList.remove(lastOccurance);
                        int id = idList.remove(lastOccurance);
                        if (this.timeMap.get(id) == null) {
                            this.parsingError(String.valueOf(Messages.getString("StapGraphParser.NoStartTime")) + name);
                            return Status.CANCEL_STATUS;
                        }
                        this.endingTimeInNS = Long.parseLong(args[1]);
                        long time = this.endingTimeInNS - this.timeMap.get(id);
                        this.timeMap.put(id, time);
                        if (id == this.firstNode) {
                            this.showTime(id, time);
                        }
                        if (this.shouldGetEndingTimeForID.contains(id)) {
                            long cumulativeTime = this.aggregateTimeMap.get(name) + Long.parseLong(args[1]);
                            this.aggregateTimeMap.put(name, cumulativeTime);
                        }
                        this.nameMaps.put(tid, nameList);
                        this.idMaps.put(tid, idList);
                    }
                    break;
                }
                default: {
                    return Status.CANCEL_STATUS;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("StapGraphParser.BadSymbol"), Messages.getString("StapGraphParser.BadSymbol"), String.valueOf(Messages.getString("StapGraphParser.BadSymbolMsg1")) + Messages.getString("StapGraphParser.BadSymbolMsg2"));
            mess.schedule();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    /*
     * Exception decompiling
     */
    private IStatus parseDotFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 25[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IStatus realTimeParsing() {
        if (!(this.internalData instanceof BufferedReader)) {
            return Status.CANCEL_STATUS;
        }
        BufferedReader buff = (BufferedReader)this.internalData;
        boolean draw = false;
        boolean first = true;
        try {
            String line;
            while ((line = buff.readLine()) != null) {
                if (this.monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (line.length() < 1) continue;
                if (first && line.contains(Messages.getString("StapGraphParser.17"))) {
                    return this.parseDotFile();
                }
                first = false;
                draw = true;
                if (line.equals("PROBE_BEGIN")) {
                    buff.mark(100);
                    String tmp = buff.readLine();
                    if (tmp == null || tmp.length() <= 0) continue;
                    char tchar = tmp.charAt(0);
                    if (tchar != '-' && tchar != '+' && tchar != '?' && tchar != '>' && tchar != '<') {
                        this.project = CoreModel.getDefault().getCModel().getCProject(tmp);
                        continue;
                    }
                    buff.reset();
                    continue;
                }
                if (line.charAt(0) == '-') {
                    this.endingTimeInNS = Long.parseLong(line.substring(1));
                    continue;
                }
                if (line.charAt(0) == '+') {
                    this.totalTime = Long.parseLong(line.substring(1));
                    this.parseEnd();
                    continue;
                }
                if (line.charAt(0) == '?') {
                    if (line.length() <= 1) continue;
                    this.parseMarked(line.substring(1));
                    continue;
                }
                if (this.parse(line) == Status.CANCEL_STATUS) break;
            }
            if (draw && this.view != null) {
                this.view.update();
                this.realTimeParsing();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private void showTime(int id, long time) {
        String tmp = this.markedMap.get(id);
        if (tmp == null) {
            tmp = "";
        }
        this.markedMap.put(id, String.valueOf(tmp) + Messages.getString("StapGraphParser.ActualTime") + time / 1000000L + Messages.getString("StapGraphParser.TimeUnits"));
    }
}

