/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.GraphModel;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph.SelectGraphWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class SelectSeriesWizardPage
extends WizardPage {
    private Text txtTitle;
    private Text txtKey;
    private Button btnKey;
    private Label lblKey;
    private Combo cboXItem;
    private Combo[] cboYItems;
    private Label[] lblYItems;
    private GraphModel model;

    public SelectSeriesWizardPage() {
        super("selectSeries");
        this.setTitle(Localization.getString("SelectSeriesWizardPage.SelectSeries"));
    }

    public void createControl(Composite parent) {
        this.model = ((SelectGraphWizard)super.getWizard()).model;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Label lblTitle = new Label(comp, 0);
        lblTitle.setText(Localization.getString("SelectSeriesWizardPage.Title"));
        this.txtTitle = new Text(comp, 2048);
        this.txtTitle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectSeriesWizardPage.this.getWizard().getContainer().updateButtons();
                if (SelectSeriesWizardPage.this.txtTitle.getText().length() == 0) {
                    SelectSeriesWizardPage.this.setErrorMessage(Localization.getString("SelectSeriesWizardPage.TitleNotSet"));
                    SelectSeriesWizardPage.this.setMessage(null);
                } else {
                    SelectSeriesWizardPage.this.setErrorMessage(null);
                    SelectSeriesWizardPage.this.setMessage("");
                }
            }
        });
        data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.width = 200;
        lblTitle.setLayoutData((Object)data1);
        data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment((Control)lblTitle, 0);
        data1.width = 200;
        this.txtTitle.setLayoutData((Object)data1);
        data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment((Control)this.txtTitle, 20);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Composite cmpGraphOpts = new Composite(comp, 0);
        cmpGraphOpts.setLayoutData((Object)data1);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpGraphOpts.setLayout((Layout)colLayout);
        String[] labels = this.model.getSeries();
        this.cboYItems = new Combo[labels.length];
        this.lblYItems = new Label[this.cboYItems.length];
        Label lblXItem = new Label(cmpGraphOpts, 0);
        lblXItem.setText(Localization.getString("SelectSeriesWizardPage.XSeries"));
        this.cboXItem = new Combo(cmpGraphOpts, 4);
        this.cboXItem.addSelectionListener((SelectionListener)new ComboSelectionListener());
        this.cboXItem.add(Localization.getString("SelectSeriesWizardPage.RowID"));
        this.cboXItem.select(0);
        new Label(cmpGraphOpts, 0);
        int i = 0;
        while (i < this.cboYItems.length) {
            this.lblYItems[i] = new Label(cmpGraphOpts, 0);
            this.lblYItems[i].setText(String.valueOf(Localization.getString("SelectSeriesWizardPage.YSeries")) + i + ":");
            this.cboYItems[i] = new Combo(cmpGraphOpts, 4);
            this.cboYItems[i].addSelectionListener((SelectionListener)new ComboSelectionListener());
            if (i > 0) {
                this.cboYItems[i].add(Localization.getString("SelectSeriesWizardPage.NA"));
                this.cboYItems[i].select(0);
                this.cboYItems[i].setVisible(false);
                this.lblYItems[i].setVisible(false);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < labels.length) {
            this.cboXItem.add(labels[i2]);
            int j = 0;
            while (j < this.lblYItems.length) {
                this.cboYItems[j].add(labels[i2]);
                ++j;
            }
            ++i2;
        }
        this.btnKey = new Button(comp, 32);
        this.btnKey.setText(Localization.getString("SelectSeriesWizardPage.UseHistoricalData"));
        this.btnKey.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectSeriesWizardPage.this.txtKey.setEnabled(SelectSeriesWizardPage.this.btnKey.getSelection());
            }
        });
        data1 = new FormData();
        data1.left = new FormAttachment((Control)cmpGraphOpts, 20);
        data1.top = new FormAttachment((Control)this.txtTitle, 0);
        data1.right = new FormAttachment(100, 0);
        this.btnKey.setLayoutData((Object)data1);
        this.lblKey = new Label(comp, 0);
        this.lblKey.setText(Localization.getString("SelectSeriesWizardPage.KeyFilter"));
        this.txtKey = new Text(comp, 2048);
        if (this.txtKey != null) {
            this.txtKey.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectSeriesWizardPage.this.getWizard().getContainer().updateButtons();
                    if (SelectSeriesWizardPage.this.txtTitle.getText().length() == 0) {
                        SelectSeriesWizardPage.this.setErrorMessage(Localization.getString("SelectSeriesWizardPage.KeyNotSet"));
                        SelectSeriesWizardPage.this.setMessage(null);
                    } else {
                        SelectSeriesWizardPage.this.setErrorMessage(null);
                        SelectSeriesWizardPage.this.setMessage("");
                    }
                }
            });
        }
        data1 = new FormData();
        data1.left = new FormAttachment((Control)cmpGraphOpts, 20);
        data1.top = new FormAttachment((Control)this.btnKey, 0);
        data1.right = new FormAttachment(80, 0);
        this.lblKey.setLayoutData((Object)data1);
        data1 = new FormData();
        data1.left = new FormAttachment((Control)cmpGraphOpts, 20);
        data1.top = new FormAttachment((Control)this.lblKey, 2);
        data1.right = new FormAttachment(80, 0);
        this.txtKey.setLayoutData((Object)data1);
        this.setControl((Control)comp);
    }

    public void setKeyEnablement(boolean required, boolean optional) {
        this.btnKey.setVisible(optional);
        this.txtKey.setVisible(required || optional);
        this.lblKey.setVisible(required || optional);
        this.txtKey.setEnabled(required);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        return this.saveDataToModel();
    }

    private boolean saveDataToModel() {
        if (this.isSeriesUnique()) {
            this.model.setTitle(this.txtTitle.getText());
            if (this.txtKey != null && this.txtKey.isEnabled()) {
                this.model.setKey(this.txtKey.getText());
            } else {
                this.model.setKey(null);
            }
            this.model.setXSeries(this.cboXItem.getSelectionIndex() - 1);
            int i = 1;
            int count = 1;
            while (i < this.cboYItems.length) {
                if (this.cboYItems[i].isVisible() && this.cboYItems[i].getSelectionIndex() != 0) {
                    ++count;
                }
                ++i;
            }
            int[] ySeries = new int[count];
            ySeries[0] = this.cboYItems[0].getSelectionIndex();
            i = 1;
            while (i < count) {
                ySeries[i] = this.cboYItems[i].getSelectionIndex() - 1;
                ++i;
            }
            this.model.setYSeries(ySeries);
            return true;
        }
        return false;
    }

    private boolean isSeriesUnique() {
        if ("".equals(this.txtTitle.getText().trim())) {
            return false;
        }
        if (this.txtKey != null && this.txtKey.isEnabled() && this.txtKey.getText().length() <= 0) {
            return false;
        }
        int i = 0;
        while (i < this.cboYItems.length) {
            if (this.cboYItems[i].isVisible()) {
                int j = i + 1;
                while (j < this.cboYItems.length) {
                    if (this.cboYItems[j].isVisible()) {
                        if (this.cboYItems[i].getSelectionIndex() < 0) {
                            return false;
                        }
                        if (this.cboYItems[j].getSelectionIndex() < 0) {
                            return false;
                        }
                        if (this.cboYItems[i].getItem(this.cboYItems[i].getSelectionIndex()).equals(this.cboYItems[j].getItem(this.cboYItems[j].getSelectionIndex()))) {
                            return false;
                        }
                    }
                    ++j;
                }
                if (this.cboYItems[i].getSelectionIndex() < 0) {
                    return false;
                }
                if (this.cboXItem.getSelectionIndex() < 0) {
                    return false;
                }
                if (this.cboYItems[i].getItem(this.cboYItems[i].getSelectionIndex()).equals(this.cboXItem.getItem(this.cboXItem.getSelectionIndex()))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.txtTitle != null) {
            this.txtTitle.dispose();
        }
        this.txtTitle = null;
        if (this.txtKey != null) {
            this.txtKey.dispose();
        }
        this.txtKey = null;
        if (this.btnKey != null) {
            this.btnKey.dispose();
        }
        this.btnKey = null;
        if (this.lblKey != null) {
            this.lblKey.dispose();
        }
        this.lblKey = null;
        if (this.cboXItem != null) {
            this.cboXItem.dispose();
        }
        this.cboXItem = null;
        if (this.cboYItems != null) {
            int i = 0;
            while (i < this.cboYItems.length) {
                if (this.cboYItems[i] != null) {
                    this.cboYItems[i].dispose();
                }
                this.cboYItems[i] = null;
                if (this.lblYItems[i] != null) {
                    this.lblYItems[i].dispose();
                }
                this.lblYItems[i] = null;
                ++i;
            }
        }
        this.cboYItems = null;
        this.lblYItems = null;
        this.model = null;
    }

    private class ComboSelectionListener
    implements SelectionListener {
        private ComboSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!SelectSeriesWizardPage.this.cboXItem.equals(e.getSource())) {
                boolean setVisible = true;
                if (GraphFactory.isMultiGraph(SelectSeriesWizardPage.this.model.getGraphID())) {
                    int i = 1;
                    while (i < SelectSeriesWizardPage.this.cboYItems.length) {
                        SelectSeriesWizardPage.this.cboYItems[i].setVisible(setVisible);
                        SelectSeriesWizardPage.this.lblYItems[i].setVisible(setVisible);
                        setVisible = SelectSeriesWizardPage.this.cboYItems[i].getSelectionIndex() > 0 && SelectSeriesWizardPage.this.cboYItems[i].isVisible();
                        ++i;
                    }
                }
            }
            if (!SelectSeriesWizardPage.this.isSeriesUnique()) {
                SelectSeriesWizardPage.this.setErrorMessage(Localization.getString("SelectSeriesWizardPage.SeriesNotSelected"));
                SelectSeriesWizardPage.this.setMessage(null);
            } else {
                SelectSeriesWizardPage.this.setErrorMessage(null);
                SelectSeriesWizardPage.this.setMessage("");
            }
            if (SelectSeriesWizardPage.this.txtTitle.getText().length() == 0) {
                SelectSeriesWizardPage.this.setErrorMessage(Localization.getString("SelectSeriesWizardPage.TitleNotSet"));
                SelectSeriesWizardPage.this.setMessage(null);
            }
            SelectSeriesWizardPage.this.getWizard().getContainer().updateButtons();
        }
    }
}

