/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statistics.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.util.TmfFixedArray;
import org.eclipse.linuxtools.tmf.ui.views.statistics.ITmfExtraEventInfo;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.AbsTmfStatisticsTree;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.Messages;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfStatisticsTreeNode;

public class TmfBaseStatisticsTree
extends AbsTmfStatisticsTree {
    public static final String HEADER_EVENT_TYPES = Messages.TmfStatisticsData_EventTypes;
    protected static final String NODE = "z";
    protected static final String ROOT_NODE_KEY = TmfBaseStatisticsTree.mergeString((String)ROOT.get(0), "z");

    public TmfBaseStatisticsTree() {
        Map<String, Set<String>> keys = this.getKeys();
        keys.put(HEADER_EVENT_TYPES, new HashSet());
        HashSet<String> temp = new HashSet<String>(8);
        temp.add(HEADER_EVENT_TYPES);
        keys.put(ROOT_NODE_KEY, temp);
        temp = new HashSet(16);
        keys.put(TmfBaseStatisticsTree.mergeString(HEADER_EVENT_TYPES, NODE), temp);
        keys.put((String)ROOT.get(0), new HashSet(2));
        this.getOrCreate((TmfFixedArray<String>)ROOT);
    }

    @Override
    public Collection<TmfStatisticsTreeNode> getChildren(TmfFixedArray<String> path) {
        LinkedList<TmfStatisticsTreeNode> result = new LinkedList<TmfStatisticsTreeNode>();
        if (path.size() % 2 == 0) {
            TmfStatisticsTreeNode current = null;
            for (String value : this.getKeys().get(path.get(path.size() - 1))) {
                current = this.get((TmfFixedArray<String>)path.append((Object)value));
                if (current == null || current.getValue().nbEvents == 0L) continue;
                result.add(current);
            }
        } else if (path.size() == 1) {
            if (path.equals((Object)ROOT)) {
                for (String value : this.getKeys().get(ROOT.get(0))) {
                    result.add(this.getOrCreate((TmfFixedArray<String>)new TmfFixedArray((Object[])new String[]{value})));
                }
            } else {
                for (String value : this.getKeys().get(ROOT_NODE_KEY)) {
                    result.add(this.getOrCreate((TmfFixedArray<String>)path.append((Object)value)));
                }
            }
        } else {
            for (String value : this.getKeys().get(TmfBaseStatisticsTree.mergeString((String)path.get(path.size() - 2), NODE))) {
                result.add(this.getOrCreate((TmfFixedArray<String>)path.append((Object)value)));
            }
        }
        return result;
    }

    @Override
    public Collection<TmfStatisticsTreeNode> getAllChildren(TmfFixedArray<String> path) {
        LinkedList<TmfStatisticsTreeNode> result = new LinkedList<TmfStatisticsTreeNode>();
        if (path.size() % 2 == 0) {
            TmfStatisticsTreeNode current = null;
            for (String value : this.getKeys().get(path.get(path.size() - 1))) {
                current = this.get((TmfFixedArray<String>)path.append((Object)value));
                if (current == null) continue;
                result.add(current);
            }
        } else if (path.size() == 1) {
            if (path.equals((Object)ROOT)) {
                for (String value : this.getKeys().get(ROOT.get(0))) {
                    result.add(this.getOrCreate((TmfFixedArray<String>)new TmfFixedArray((Object[])new String[]{value})));
                }
            } else {
                for (String value : this.getKeys().get(ROOT_NODE_KEY)) {
                    result.add(this.getOrCreate((TmfFixedArray<String>)path.append((Object)value)));
                }
            }
        } else {
            for (String value : this.getKeys().get(TmfBaseStatisticsTree.mergeString((String)path.get(path.size() - 2), NODE))) {
                result.add(this.getOrCreate((TmfFixedArray<String>)path.append((Object)value)));
            }
        }
        return result;
    }

    protected TmfFixedArray<String>[] getTypePaths(ITmfEvent event, ITmfExtraEventInfo extraInfo) {
        String trace = extraInfo.getTraceName();
        String type = event.getType().toString();
        TmfFixedArray[] paths = new TmfFixedArray[]{new TmfFixedArray((Object[])new String[]{trace, HEADER_EVENT_TYPES, type})};
        return paths;
    }

    protected TmfFixedArray<String>[] getNormalPaths(ITmfEvent event, ITmfExtraEventInfo extraInfo) {
        String trace = extraInfo.getTraceName();
        TmfFixedArray[] paths = new TmfFixedArray[]{new TmfFixedArray((Object[])new String[]{trace})};
        return paths;
    }

    @Override
    public void increase(ITmfEvent event, ITmfExtraEventInfo extraInfo, int values) {
    }

    @Override
    public void registerEvent(ITmfEvent event, ITmfExtraEventInfo extraInfo) {
        TmfFixedArray<String> path;
        TmfFixedArray<String>[] paths;
        TmfFixedArray<String>[] tmfFixedArrayArray = paths = this.getNormalPaths(event, extraInfo);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            path = tmfFixedArrayArray[n2];
            ++this.getOrCreate(path).getValue().nbEvents;
            ++n2;
        }
        tmfFixedArrayArray = paths = this.getTypePaths(event, extraInfo);
        n = paths.length;
        n2 = 0;
        while (n2 < n) {
            path = tmfFixedArrayArray[n2];
            ++this.getOrCreate(path).getValue().nbEvents;
            ++n2;
        }
    }

    @Override
    protected void registerName(TmfFixedArray<String> path) {
        if (path.size() == 1) {
            if (!path.equals((Object)ROOT)) {
                this.getKeys().get(ROOT.get(0)).add((String)path.get(0));
            }
        } else if (path.size() % 2 != 0) {
            this.getKeys().get(path.get(path.size() - 2)).add((String)path.get(path.size() - 1));
        }
    }
}

