/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class RenameTraceDialog
extends SelectionStatusDialog {
    private final TmfTraceElement fTrace;
    private Text fNewTraceNameText;
    private String fNewTraceName;
    private IContainer fTraceFolder;
    private TmfProjectElement fProject;

    public RenameTraceDialog(Shell shell, TmfTraceElement trace) {
        super(shell);
        this.fTrace = trace;
        TmfTraceFolder folder = (TmfTraceFolder)trace.getParent();
        this.fTraceFolder = folder.getResource();
        this.fProject = trace.getProject();
        this.setTitle(Messages.RenameTraceDialog_DialogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createNewTraceNameGroup(composite);
        return composite;
    }

    private void createNewTraceNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        Label oldTraceLabel = new Label(folderGroup, 0);
        oldTraceLabel.setFont(font);
        oldTraceLabel.setText(Messages.RenameTraceDialog_TraceName);
        Text oldTraceName = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        oldTraceName.setLayoutData((Object)data);
        oldTraceName.setFont(font);
        oldTraceName.setText(this.fTrace.getName());
        oldTraceName.setEnabled(false);
        Label newTaceLabel = new Label(folderGroup, 0);
        newTaceLabel.setFont(font);
        newTaceLabel.setText(Messages.RenameTraceDialog_TraceNewName);
        this.fNewTraceNameText = new Text(folderGroup, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.fNewTraceNameText.setLayoutData((Object)data);
        this.fNewTraceNameText.setFont(font);
        this.fNewTraceNameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                RenameTraceDialog.this.validateNewTraceName();
            }
        });
    }

    public String getNewTraceName() {
        return this.fNewTraceName;
    }

    private void validateNewTraceName() {
        this.fNewTraceName = this.fNewTraceNameText.getText();
        IWorkspace workspace = this.fTraceFolder.getWorkspace();
        IStatus nameStatus = workspace.validateName(this.fNewTraceName, 2);
        if ("".equals(this.fNewTraceName)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", 4, Messages.Dialog_EmptyNameError, null));
            return;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return;
        }
        Path path = new Path(this.fNewTraceName);
        if (this.fTraceFolder.getFolder((IPath)path).exists() || this.fTraceFolder.getFile((IPath)path).exists()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.linuxtools.tmf.ui", ""));
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        IResource trace = this.renameTrace(this.fNewTraceNameText.getText());
        if (trace == null) {
            return;
        }
        this.setSelectionResult(new IResource[]{trace});
        super.okPressed();
        if (this.fProject != null) {
            this.fProject.refresh();
        }
    }

    private IResource renameTrace(final String newName) {
        IPath oldPath = this.fTrace.getResource().getFullPath();
        final IPath newPath = oldPath.append("../" + newName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", 1000);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (RenameTraceDialog.this.fTrace.getResource() instanceof IFolder) {
                        IFolder folder = (IFolder)RenameTraceDialog.this.fTrace.getResource();
                        IFile bookmarksFile = folder.getFile(String.valueOf(RenameTraceDialog.this.fTrace.getName()) + '_');
                        IFile newBookmarksFile = folder.getFile(String.valueOf(newName) + '_');
                        if (bookmarksFile.exists() && !newBookmarksFile.exists()) {
                            IPath newBookmarksPath = newBookmarksFile.getFullPath();
                            bookmarksFile.move(newBookmarksPath, 33, null);
                        }
                    }
                    RenameTraceDialog.this.fTrace.getResource().move(newPath, 33, null);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"", (String)NLS.bind((String)"", (Object)exception.getTargetException().getMessage()));
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        return this.fTrace.getResource();
    }
}

