/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui.auth;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.CertificateCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.OpenIdCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.commons.repositories.ui.auth.AbstractCredentialsProviderUi;
import org.eclipse.mylyn.internal.commons.repositories.ui.auth.CertificateCredentialsProviderUi;
import org.eclipse.mylyn.internal.commons.repositories.ui.auth.OpenIdCredentialsProviderUi;
import org.eclipse.mylyn.internal.commons.repositories.ui.auth.UserCredentialsProviderUi;
import org.eclipse.ui.PlatformUI;

public class RepositoryAuthenticator<T extends AuthenticationCredentials> {
    private static final Object lock = new Object();
    private final AuthenticationRequest<AuthenticationType<T>> request;

    public RepositoryAuthenticator(AuthenticationRequest<AuthenticationType<T>> request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T open(IProgressMonitor monitor) {
        AuthenticationCredentials oldCredentials = this.request.getLocation().getCredentials(this.request.getAuthenticationType());
        Object object = lock;
        synchronized (object) {
            AuthenticationCredentials newCredentials = this.request.getLocation().getCredentials(this.request.getAuthenticationType());
            if (!CoreUtil.areEqual((Object)oldCredentials, (Object)newCredentials)) {
                return (T)newCredentials;
            }
            if (PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                throw new UnsupportedOperationException();
            }
            AtomicReference status = new AtomicReference();
            AtomicReference requestedCredentials = new AtomicReference();
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                AbstractCredentialsProviderUi<T> provider = this.getCredentialsProviderUi();
                IStatus result = provider.open(WorkbenchUtil.getShell(), this.request);
                status.set(result);
                requestedCredentials.set(provider.getCredentials());
            });
            if (status.get() == null) {
                throw new IllegalStateException();
            }
            if (((IStatus)status.get()).getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            if (!((IStatus)status.get()).isOK()) {
                StatusHandler.log((IStatus)((IStatus)status.get()));
                throw new UnsupportedOperationException();
            }
            return (T)((AuthenticationCredentials)requestedCredentials.get());
        }
    }

    protected AbstractCredentialsProviderUi<T> getCredentialsProviderUi() {
        Class credentialsType = this.request.getAuthenticationType().getCredentialsType();
        if (credentialsType == UserCredentials.class) {
            return new UserCredentialsProviderUi();
        }
        if (credentialsType == CertificateCredentials.class) {
            return new CertificateCredentialsProviderUi();
        }
        if (credentialsType == OpenIdCredentials.class) {
            return new OpenIdCredentialsProviderUi();
        }
        return null;
    }
}

