/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar.raw;

import java.io.Reader;
import java.util.List;
import org.eclipse.tm4e.core.internal.grammar.raw.RawCaptures;
import org.eclipse.tm4e.core.internal.grammar.raw.RawGrammar;
import org.eclipse.tm4e.core.internal.grammar.raw.RawRepository;
import org.eclipse.tm4e.core.internal.grammar.raw.RawRule;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.eclipse.tm4e.core.internal.parser.TMParser;
import org.eclipse.tm4e.core.internal.parser.TMParserJSON;
import org.eclipse.tm4e.core.internal.parser.TMParserPList;
import org.eclipse.tm4e.core.internal.parser.TMParserYAML;
import org.eclipse.tm4e.core.registry.IGrammarSource;

public final class RawGrammarReader {
    public static final TMParser.ObjectFactory<RawGrammar> OBJECT_FACTORY = new TMParser.ObjectFactory<RawGrammar>(){

        @Override
        public RawGrammar createRoot() {
            return new RawGrammar();
        }

        @Override
        public PropertySettable<?> createChild(TMParser.PropertyPath path, Class<?> sourceType) {
            return switch (path.last().toString()) {
                case "repository" -> new RawRepository();
                case "whileCaptures", "endCaptures", "captures", "beginCaptures" -> new RawCaptures();
                default -> List.class.isAssignableFrom(sourceType) ? new PropertySettable.ArrayList() : new RawRule();
            };
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RawGrammar readGrammar(IGrammarSource source) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Reader reader = source.getReader();){
            switch (source.getContentType()) {
                case JSON: {
                    RawGrammar rawGrammar = TMParserJSON.INSTANCE.parse(reader, OBJECT_FACTORY);
                    return rawGrammar;
                }
                case YAML: {
                    RawGrammar rawGrammar = TMParserYAML.INSTANCE.parse(reader, OBJECT_FACTORY);
                    return rawGrammar;
                }
                default: {
                    RawGrammar rawGrammar = TMParserPList.INSTANCE.parse(reader, OBJECT_FACTORY);
                    return rawGrammar;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            } else {
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private RawGrammarReader() {
    }
}

