/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.core.DelegatingEngineExecutionListener;

class OutcomeDelayingEngineExecutionListener
extends DelegatingEngineExecutionListener {
    private final TestDescriptor engineDescriptor;
    private volatile boolean engineStarted;
    private volatile @Nullable Outcome outcome;
    private volatile @Nullable String skipReason;
    private volatile @Nullable TestExecutionResult executionResult;

    OutcomeDelayingEngineExecutionListener(EngineExecutionListener delegate, TestDescriptor engineDescriptor) {
        super(delegate);
        this.engineDescriptor = engineDescriptor;
    }

    @Override
    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        if (testDescriptor == this.engineDescriptor) {
            this.outcome = Outcome.SKIPPED;
            this.skipReason = reason;
        } else {
            super.executionSkipped(testDescriptor, reason);
        }
    }

    @Override
    public void executionStarted(TestDescriptor testDescriptor) {
        if (testDescriptor == this.engineDescriptor) {
            this.engineStarted = true;
        }
        super.executionStarted(testDescriptor);
    }

    @Override
    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult executionResult) {
        if (testDescriptor == this.engineDescriptor) {
            this.outcome = Outcome.FINISHED;
            this.executionResult = executionResult;
        } else {
            super.executionFinished(testDescriptor, executionResult);
        }
    }

    void reportEngineOutcome() {
        if (this.outcome == Outcome.FINISHED) {
            super.executionFinished(this.engineDescriptor, Objects.requireNonNull(this.executionResult));
        } else if (this.outcome == Outcome.SKIPPED) {
            super.executionSkipped(this.engineDescriptor, Objects.requireNonNull(this.skipReason));
        }
    }

    void reportEngineStartIfNecessary() {
        if (!this.engineStarted) {
            super.executionStarted(this.engineDescriptor);
        }
    }

    void reportEngineFailure(Throwable throwable) {
        Optional.ofNullable(this.executionResult).flatMap(TestExecutionResult::getThrowable).ifPresent(throwable::addSuppressed);
        super.executionFinished(this.engineDescriptor, TestExecutionResult.failed((Throwable)throwable));
    }

    private static enum Outcome {
        SKIPPED,
        FINISHED;

    }
}

