/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.requests;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypeDebugOptions;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;

public class CreateElementRequest
extends AbstractEditCommandRequest {
    private EObject container;
    private EReference containmentFeature;
    private final IElementType elementType;
    private EObject newElement;
    private ICommand editContextCommand;
    private boolean requestingEditContext;
    private GetEditContextRequest editContextRequest;

    public CreateElementRequest(TransactionalEditingDomain editingDomain, EObject container, IElementType elementType) {
        this(editingDomain, container, elementType, null);
    }

    public CreateElementRequest(EObject container, IElementType elementType) {
        this(TransactionUtil.getEditingDomain((EObject)container), container, elementType, null);
    }

    public CreateElementRequest(IElementType elementType) {
        this(null, null, elementType, null);
    }

    public CreateElementRequest(TransactionalEditingDomain editingDomain, IElementType elementType) {
        this(editingDomain, null, elementType, null);
    }

    public CreateElementRequest(TransactionalEditingDomain editingDomain, EObject container, IElementType elementType, EReference containmentFeature) {
        super(editingDomain);
        this.container = container;
        this.elementType = elementType;
        this.containmentFeature = containmentFeature;
    }

    public CreateElementRequest(EObject container, IElementType elementType, EReference containmentFeature) {
        this(TransactionUtil.getEditingDomain((EObject)container), container, elementType, containmentFeature);
    }

    public EObject getNewElement() {
        return this.newElement;
    }

    public void setNewElement(EObject element) {
        this.newElement = element;
    }

    public EReference getContainmentFeature() {
        return this.containmentFeature;
    }

    public void setContainmentFeature(EReference containmentFeature) {
        if (this.containmentFeature != containmentFeature) {
            this.containmentFeature = containmentFeature;
            this.invalidateEditHelperContext();
        }
    }

    public void initializeContainmentFeature(EReference feature) {
        if (this.containmentFeature != feature) {
            this.containmentFeature = feature;
        }
    }

    public EObject getContainer() {
        return this.container;
    }

    public EObject createContainer() {
        Object result = null;
        ICommand contextCommand = this.getEditContextCommand();
        if (contextCommand != null && contextCommand.canExecute()) {
            try {
                contextCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                CommandResult commandResult = contextCommand.getCommandResult();
                if (commandResult.getStatus().getCode() == 0) {
                    result = commandResult.getReturnValue();
                }
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)EMFTypePlugin.getPlugin(), (String)EMFTypeDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"createContainer", (Throwable)e);
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)4, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (result == null || result instanceof EObject) {
            this.container = (EObject)result;
        }
        return this.getContainer();
    }

    private ICommand getEditContextCommand() {
        if (this.editContextCommand == null) {
            this.requestingEditContext = true;
            try {
                this.editContextCommand = this.getElementType().getEditCommand(this.getEditContextRequest());
            }
            finally {
                this.requestingEditContext = false;
            }
        }
        return this.editContextCommand;
    }

    private GetEditContextRequest getEditContextRequest() {
        if (this.editContextRequest == null) {
            this.editContextRequest = new GetEditContextRequest(this.getEditingDomain(), this, this.getElementType());
            this.editContextRequest.setEditContext(this.getContainer());
            this.editContextRequest.setClientContext(this.getClientContext());
            this.editContextRequest.addParameters(this.getParameters());
        }
        return this.editContextRequest;
    }

    public void setContainer(EObject container) {
        if (this.container != container) {
            this.container = container;
            if (!this.requestingEditContext) {
                this.editContextCommand = null;
                if (this.editContextRequest != null) {
                    this.editContextRequest.setEditContext(container);
                }
            }
            this.invalidateContainmentFeature();
        }
    }

    @Override
    public void setClientContext(IClientContext clientContext) {
        super.setClientContext(clientContext);
        if (this.editContextRequest != null) {
            this.editContextRequest.setClientContext(clientContext);
        }
    }

    @Override
    public IClientContext getClientContext() {
        IClientContext result = super.getClientContext();
        IElementType type = this.getElementType();
        if (result == null && type != null) {
            result = ClientContextManager.getInstance().getBinding(type);
        }
        return result;
    }

    public IElementType getElementType() {
        return this.elementType;
    }

    @Override
    public List getElementsToEdit() {
        if (this.getContainer() != null) {
            return Collections.singletonList(this.getContainer());
        }
        return super.getElementsToEdit();
    }

    @Override
    protected String getDefaultLabel() {
        String label = MessageFormat.format(EMFTypeCoreMessages.Request_Label_Create, this.getElementType().getDisplayName());
        return label;
    }

    @Override
    public Object getEditHelperContext() {
        ICommand contextCommand = this.getEditContextCommand();
        if (contextCommand != null && contextCommand.canExecute()) {
            return this.getEditContextRequest().getEditContext();
        }
        return contextCommand;
    }

    @Override
    public void setParameter(String parameterName, Object value) {
        super.setParameter(parameterName, value);
    }

    protected void invalidateEditHelperContext() {
        if (!this.requestingEditContext) {
            this.editContextCommand = null;
            this.editContextRequest = null;
        }
    }

    protected void invalidateContainmentFeature() {
        if (!this.requestingEditContext) {
            this.containmentFeature = null;
        }
    }

    @Override
    public TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain result = super.getEditingDomain();
        EObject c = this.getContainer();
        if (result == null && c != null) {
            result = TransactionUtil.getEditingDomain((EObject)c);
        }
        return result;
    }
}

