/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.ManagedContainerViewProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public class PluginContainerViewProvider
extends ManagedContainerViewProvider {
    public static final PluginContainerViewProvider INSTANCE = new PluginContainerViewProvider();
    private static final String REGEX = "cdo:.*";
    private static final int PRIORITY = 300;

    public PluginContainerViewProvider() {
        super((IManagedContainer)IPluginContainer.INSTANCE, REGEX, 300);
    }

    @Override
    public CDOView getView(URI uri, ResourceSet resourceSet) {
        IManagedContainer container = this.getContainer();
        if (container == null) {
            return null;
        }
        String repoUUID = PluginContainerViewProvider.getRepositoryUUID(uri);
        if (repoUUID == null) {
            return null;
        }
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.sessions");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view;
            Object element = objectArray[n2];
            CDOSession session = (CDOSession)element;
            String uuid = session.getRepositoryInfo().getUUID();
            if (repoUUID.equals(uuid) && (view = this.openView(session, resourceSet)) != null) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public URI getResourceURI(CDOView view, String path) {
        String repositoryUUID = PluginContainerViewProvider.getRepositoryUUID(view);
        return this.getResourceURI(repositoryUUID, path);
    }

    public URI getResourceURI(String repositoryUUID, String path) {
        URI uri = URI.createHierarchicalURI((String)"cdo", (String)repositoryUUID, null, null, null);
        return CDOURIUtil.appendResourcePath(uri, path);
    }

    @Override
    public URI getViewURI(URI uri) {
        if (uri == null) {
            return null;
        }
        String scheme = uri.scheme();
        if (scheme == null) {
            return null;
        }
        if (!scheme.equals("cdo")) {
            return null;
        }
        return super.getViewURI(uri);
    }

    protected CDOView openView(CDOSession session, ResourceSet resourceSet) {
        return session.openTransaction(resourceSet);
    }

    public static String getRepositoryUUID(CDOView view) {
        return view.getSession().getRepositoryInfo().getUUID();
    }

    public static String getRepositoryUUID(URI uri) {
        return uri.authority();
    }
}

