/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.om.job.OMJob;

public abstract class TaskQueue<T> {
    private final Set<T> queue = new LinkedHashSet<T>();
    private TaskJob job;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(T task) {
        Set<T> set = this.queue;
        synchronized (set) {
            this.queue.remove(task);
            if (this.job != null && this.job.currentTask == task) {
                try {
                    this.job.cancel();
                }
                finally {
                    this.job = null;
                }
            }
            if (this.job != null) {
                this.queue.add(task);
            } else {
                this.job = new TaskJob(task);
                this.job.schedule();
            }
        }
    }

    protected String getJobName(T task) {
        return "Execute " + task;
    }

    protected void handleException(T task, Exception ex) {
        OM.LOG.error(this.getJobName(task), ex);
    }

    protected abstract void execute(T var1, IProgressMonitor var2) throws Exception;

    private final class TaskJob
    extends OMJob {
        private T currentTask;

        public TaskJob(T task) {
            super(TaskQueue.this.getJobName(task));
            this.currentTask = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        protected IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            try {
                TaskQueue.this.execute(this.currentTask, monitor);
                iStatus = Status.OK_STATUS;
            }
            catch (OperationCanceledException ex) {
                IStatus iStatus2 = Status.CANCEL_STATUS;
                Set set = TaskQueue.this.queue;
                synchronized (set) {
                    if (TaskQueue.this.queue.isEmpty() || monitor.isCanceled()) {
                        this.currentTask = null;
                        TaskQueue.this.job = null;
                    } else {
                        Iterator iterator = TaskQueue.this.queue.iterator();
                        this.currentTask = iterator.next();
                        iterator.remove();
                        this.setName(String.valueOf(TaskQueue.this.getJobName(this.currentTask)) + " (rescheduled)");
                        this.schedule();
                    }
                }
                return iStatus2;
            }
            catch (Exception ex2) {
                TaskQueue.this.handleException(this.currentTask, ex2);
                IStatus iStatus3 = Status.OK_STATUS;
                {
                    catch (Throwable throwable) {
                        Set set = TaskQueue.this.queue;
                        synchronized (set) {
                            if (TaskQueue.this.queue.isEmpty() || monitor.isCanceled()) {
                                this.currentTask = null;
                                TaskQueue.this.job = null;
                            } else {
                                Iterator iterator = TaskQueue.this.queue.iterator();
                                this.currentTask = iterator.next();
                                iterator.remove();
                                this.setName(String.valueOf(TaskQueue.this.getJobName(this.currentTask)) + " (rescheduled)");
                                this.schedule();
                            }
                        }
                        throw throwable;
                    }
                }
                Set set = TaskQueue.this.queue;
                synchronized (set) {
                    if (TaskQueue.this.queue.isEmpty() || monitor.isCanceled()) {
                        this.currentTask = null;
                        TaskQueue.this.job = null;
                    } else {
                        Iterator iterator = TaskQueue.this.queue.iterator();
                        this.currentTask = iterator.next();
                        iterator.remove();
                        this.setName(String.valueOf(TaskQueue.this.getJobName(this.currentTask)) + " (rescheduled)");
                        this.schedule();
                    }
                }
                return iStatus3;
            }
            Set set = TaskQueue.this.queue;
            synchronized (set) {
                if (TaskQueue.this.queue.isEmpty() || monitor.isCanceled()) {
                    this.currentTask = null;
                    TaskQueue.this.job = null;
                } else {
                    Iterator iterator = TaskQueue.this.queue.iterator();
                    this.currentTask = iterator.next();
                    iterator.remove();
                    this.setName(String.valueOf(TaskQueue.this.getJobName(this.currentTask)) + " (rescheduled)");
                    this.schedule();
                }
            }
            return iStatus;
        }
    }
}

