/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder;

import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.UDFNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.swt.widgets.Combo;

public class CloudscapeFunctionNamesAndSignatures {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String cloudscapeAll = Messages._UI_FCN_ALL;
    public static final String cloudscapeAggregate = Messages._UI_FCN_AGGREGATE;
    public static final String cloudscapeNotSupported = Messages._UI_FCN_NOT_SUPPORTED;
    public static String dbUDF = Messages._UI_FCN_UDF;
    private static final String[] allFunctions = new String[]{"ABSOLUTE", "AVG", "BIT_LENGTH", "CHAR_LENGTH", "CHARACTER_LENGTH", "COUNT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "EXTRACT", "LOCATE", "LOWER", "LTRIM", "MAX", "MIN", "OCTET_LENGTH", "RTRIM", "RUNTIMESTATISTICS", "SESSION_USER", "SQRT", "SUBSTRING", "SUBSTR", "SUM", "TRIM", "UPPER", "USER"};
    private static final String[] allColumnSupportedFunctions = allFunctions;
    private static final String[] functionsSupportingStar = new String[]{"COUNT"};
    private static final String[] unsupportedFunctions = new String[]{"EXTRACT", "TRIM"};
    private static final String[] noBracketFunctions = new String[]{"CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "SESSION_USER", "USER"};
    private static final String[] aggregateFunctions = new String[]{"AVG", "COUNT", "MAX", "MIN", "SUM"};

    public static Object[][] getParms(String func) {
        Object[][] list = new Object[1][2];
        list[0][0] = "???";
        list[0][1] = "???";
        if (func.equals("ABSOLUTE")) {
            list[0][0] = "numeric_expression";
            list[0][1] = "numeric_expression";
        } else if (func.equals("AVG")) {
            list[0][0] = "numeric_expression";
            list[0][1] = "expression";
        } else if (func.equals("BIT_LENGTH")) {
            list[0][0] = "numeric_expression";
            list[0][1] = "expression";
        } else if (func.equals("CHAR_LENGTH") || func.equals("CHARACTER_LENGTH")) {
            list[0][0] = "numeric_expression";
            list[0][1] = "string_expression";
        } else if (func.equals("COUNT")) {
            list[0][0] = "numeric_expression";
            list[0][1] = "expression";
        } else if (func.equals("CURRENT_DATE")) {
            list = new Object[1][1];
            list[0][0] = "date";
        } else if (func.equals("CURRENT_TIME")) {
            list = new Object[1][1];
            list[0][0] = "time";
        } else if (func.equals("CURRENT_TIMESTAMP")) {
            list = new Object[1][1];
            list[0][0] = "timestamp";
        } else if (func.equals("CURRENT_USER") || func.equals("SESSION_USER") || func.equals("USER")) {
            list = new Object[1][1];
            list[0][0] = "string";
        } else if (func.equals("EXTRACT")) {
            list = new Object[1][1];
            list[0][0] = cloudscapeNotSupported;
        } else if (func.equals("LOCATE")) {
            list = new Object[][]{new Object[3], new Object[4]};
            list[0][0] = "integer";
            list[0][1] = "char_expression";
            list[0][2] = "char_expression";
            list[1][0] = "integer";
            list[1][1] = "char_expression";
            list[1][2] = "char_expression";
            list[1][3] = "integer";
        } else if (func.equals("LOWER")) {
            list[0][0] = "string_expression";
            list[0][1] = "string_expression";
        } else if (func.equals("LTRIM")) {
            list = new Object[][]{new Object[2], new Object[3]};
            list[0][0] = "string_expression";
            list[0][1] = "string_expression";
            list[1][0] = "string_expression";
            list[1][1] = "string_expression";
            list[1][2] = "char_expression";
        } else if (func.equals("MAX")) {
            list[0][0] = "expression";
            list[0][1] = "expression";
        } else if (func.equals("MIN")) {
            list[0][0] = "expression";
            list[0][1] = "expression";
        } else if (func.equals("OCTET_LENGTH")) {
            list[0][0] = "int";
            list[0][1] = "expression";
        } else if (func.equals("RTRIM")) {
            list = new Object[][]{new Object[2], new Object[3]};
            list[0][0] = "string_expression";
            list[0][1] = "string_expression";
            list[1][0] = "string_expression";
            list[1][1] = "string_expression";
            list[1][2] = "char_expression";
        } else if (func.equals("RUNTIMESTATISTICS")) {
            list = new Object[1][1];
            list[0][0] = "RunTimeStatistics";
        } else if (func.equals("SQRT")) {
            list[0][0] = "numeric_expression";
            list[0][1] = "numeric_expression";
        } else if (func.equals("SUBSTR") || func.equals("SUBSTRING")) {
            list = new Object[][]{new Object[3], new Object[4]};
            list[0][0] = "string_expression";
            list[0][1] = "string_expression";
            list[0][2] = "start_expression";
            list[1][0] = "string_expression";
            list[1][1] = "string_expression";
            list[1][2] = "start_expression";
            list[1][3] = "length";
        } else if (func.equals("SUM")) {
            list[0][0] = "expression";
            list[0][1] = "expression";
        } else if (func.equals("TRIM")) {
            list = new Object[1][1];
            list[0][0] = cloudscapeNotSupported;
        } else if (func.equals("UPPER")) {
            list[0][0] = "string_expression";
            list[0][1] = "string_expression";
        } else {
            list = UDFNamesAndSignatures.getUDFParams(func);
        }
        return list;
    }

    public static Object[][] getParameterFormats(String functionName) {
        return CloudscapeFunctionNamesAndSignatures.getParms(functionName);
    }

    public static void fillCategoryCombo(Combo functionsCategoryCombo, boolean isColumn) {
        if (!isColumn) {
            functionsCategoryCombo.add(cloudscapeAll);
            functionsCategoryCombo.add(cloudscapeAggregate);
            functionsCategoryCombo.add(dbUDF);
        } else {
            functionsCategoryCombo.add(cloudscapeAll);
            functionsCategoryCombo.add(cloudscapeAggregate);
            functionsCategoryCombo.add(dbUDF);
        }
    }

    public static boolean isFunctionSupportingStar(String s) {
        List<String> funcList = Arrays.asList(functionsSupportingStar);
        return funcList.contains(s);
    }

    public static boolean requiresNoBrackets(String functionName) {
        List<String> funcList = Arrays.asList(noBracketFunctions);
        return funcList.contains(functionName);
    }

    public static boolean isNotSupported(String functionName) {
        List<String> funcList = Arrays.asList(unsupportedFunctions);
        return funcList.contains(functionName);
    }

    public static String[] getFunctionList(String category, boolean isColumn, SQLDomainModel domainModel) {
        if (category.equals(cloudscapeAll)) {
            if (!isColumn) {
                return UDFNamesAndSignatures.mergeTwoArrays(allFunctions, UDFNamesAndSignatures.getUDFNames(domainModel));
            }
            return UDFNamesAndSignatures.mergeTwoArrays(allColumnSupportedFunctions, UDFNamesAndSignatures.getUDFNames(domainModel));
        }
        if (category.equals(cloudscapeAggregate)) {
            return aggregateFunctions;
        }
        if (category.equals(dbUDF)) {
            return UDFNamesAndSignatures.getUDFNames(domainModel);
        }
        return UDFNamesAndSignatures.mergeTwoArrays(allFunctions, UDFNamesAndSignatures.getUDFNames(domainModel));
    }
}

