/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.viewer;

import java.util.regex.Pattern;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.HtmlTextPresentationParser;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class HtmlTextPresenter
implements DefaultInformationControl.IInformationPresenter,
DefaultInformationControl.IInformationPresenterExtension {
    private static Pattern HTML_OPEN_TAG_PATTERN = Pattern.compile("<html", 2);

    public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        return this.updatePresentation((Drawable)display, hoverInfo, presentation, maxWidth, maxHeight);
    }

    public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        if (hoverInfo == null || hoverInfo.length() == 0) {
            return hoverInfo;
        }
        HtmlTextPresentationParser parser = new HtmlTextPresentationParser();
        parser.setPresentation(presentation);
        parser.setDefaultFont(JFaceResources.getFontRegistry().defaultFont());
        Object html = hoverInfo;
        if (!HTML_OPEN_TAG_PATTERN.matcher((CharSequence)html).find()) {
            html = "<html><body>" + (String)html + "</body></html>";
        }
        GC gc = new GC(drawable);
        try {
            html = ((String)html).replace("<br>", "<br/>");
            parser.setMaxWidth(maxWidth);
            parser.setGC(gc);
            parser.parse((String)html);
            String string = parser.getText();
            return string;
        }
        catch (Exception e) {
            String string = this.exceptionToHoverInfo(hoverInfo, presentation, e);
            return string;
        }
        finally {
            gc.dispose();
        }
    }

    protected String exceptionToHoverInfo(String hoverInfo, TextPresentation presentation, Exception e) {
        presentation.clear();
        return hoverInfo;
    }
}

