/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.extension.CExternalSettingProvider;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class HeadlessBuilderExternalSettingsProvider
extends CExternalSettingProvider {
    private static final String ID = "org.eclipse.cdt.managedbuilder.core.headlessSettings";
    static List<ICSettingEntry> additionalSettings = new ArrayList<ICSettingEntry>();

    public CExternalSetting[] getSettings(IProject project, ICConfigurationDescription cfg) {
        if (additionalSettings.isEmpty()) {
            return new CExternalSetting[0];
        }
        return new CExternalSetting[]{new CExternalSetting(null, null, null, additionalSettings.toArray(new ICSettingEntry[additionalSettings.size()]))};
    }

    static void hookExternalSettingsProvider() {
        if (additionalSettings.isEmpty()) {
            return;
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project);
            if (desc != null) {
                ICConfigurationDescription[] iCConfigurationDescriptionArray = desc.getConfigurations();
                int n3 = iCConfigurationDescriptionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n4];
                    ArrayList<String> settingIds = new ArrayList<String>(Arrays.asList(cfg.getExternalSettingsProviderIds()));
                    settingIds.add(ID);
                    String[] newSettingIds = (String[])settingIds.toArray(String[]::new);
                    cfg.setExternalSettingsProviderIds(newSettingIds);
                    ++n4;
                }
                try {
                    CoreModel.getDefault().setProjectDescription(project, desc);
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            }
            ++n2;
        }
    }

    static void unhookExternalSettingsProvider() {
        if (additionalSettings.isEmpty()) {
            return;
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project);
            if (desc != null) {
                ICConfigurationDescription[] iCConfigurationDescriptionArray = desc.getConfigurations();
                int n3 = iCConfigurationDescriptionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n4];
                    ArrayList<String> extSettingIds = new ArrayList<String>(Arrays.asList(cfg.getExternalSettingsProviderIds()));
                    Iterator<String> it = extSettingIds.iterator();
                    while (it.hasNext()) {
                        if (!ID.equals(it.next())) continue;
                        it.remove();
                    }
                    cfg.setExternalSettingsProviderIds(extSettingIds.toArray(new String[extSettingIds.size()]));
                    ++n4;
                }
                try {
                    CoreModel.getDefault().setProjectDescription(project, desc);
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            }
            ++n2;
        }
    }
}

