/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.IMoveToAddress;
import org.eclipse.cdt.debug.internal.ui.actions.IMoveToLineTarget;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblySelection;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblySelection;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class DisassemblyMoveToLineAdapter
implements IMoveToLineTarget {
    public void moveToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        if (part instanceof IDisassemblyPart && selection instanceof ITextSelection) {
            IMoveToAddress moveToAddress;
            IDisassemblySelection disassemblySelection;
            IAddress address;
            if (!(selection instanceof IDisassemblySelection)) {
                selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
            }
            if ((address = (disassemblySelection = (IDisassemblySelection)selection).getStartAddress()) != null && target instanceof IAdaptable && (moveToAddress = (IMoveToAddress)((IAdaptable)target).getAdapter(IMoveToAddress.class)) != null && moveToAddress.canMoveToAddress(address)) {
                try {
                    moveToAddress.moveToAddress(address);
                }
                catch (DebugException e) {
                    this.failed(e);
                }
            }
        }
    }

    public boolean canMoveToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable && part instanceof IDisassemblyPart && selection instanceof ITextSelection) {
            IDisassemblySelection disassemblySelection;
            IAddress address;
            IMoveToAddress moveToAddress = (IMoveToAddress)((IAdaptable)target).getAdapter(IMoveToAddress.class);
            if (moveToAddress == null) {
                return false;
            }
            if (!(selection instanceof IDisassemblySelection)) {
                selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
            }
            if ((address = (disassemblySelection = (IDisassemblySelection)selection).getStartAddress()) == null) {
                return false;
            }
            return moveToAddress.canMoveToAddress(address);
        }
        return false;
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10004, "MoveToLine failed", null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10004, e.getMessage(), e));
        DsfUIPlugin.log((IStatus)ms);
    }
}

