/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.urlhandling;

import java.util.Map;
import org.eclipse.epp.internal.mpc.ui.urlhandling.MarketplaceUrlUtil;
import org.eclipse.epp.internal.mpc.ui.urlhandling.SolutionUrlHandler;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;

public class HttpSolutionUrlHandler
implements SolutionUrlHandler {
    @Override
    public boolean handles(String url) {
        return url != null && url.toLowerCase().startsWith("http");
    }

    @Override
    public boolean isPotentialSolution(String url) {
        return url.contains("mpc_install");
    }

    @Override
    public MarketplaceUrlHandler.SolutionInstallationInfo parse(String url) {
        String installId = null;
        String state = null;
        Map<String, String> query = MarketplaceUrlUtil.parseQuery(url);
        if (query != null) {
            installId = MarketplaceUrlUtil.getInstallId(query);
            state = MarketplaceUrlUtil.getMpcState(query);
        }
        if (installId != null) {
            CatalogDescriptor descriptor = MarketplaceUrlUtil.findCatalogDescriptor(url, true);
            MarketplaceUrlHandler.SolutionInstallationInfo info = new MarketplaceUrlHandler.SolutionInstallationInfo(installId, state, descriptor);
            info.setRequestUrl(url);
            return info;
        }
        return null;
    }

    @Override
    public String getMPCState(String url) {
        Map<String, String> query = MarketplaceUrlUtil.parseQuery(url);
        return query == null ? null : MarketplaceUrlUtil.getMpcState(query);
    }
}

