/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.widgets;

import java.io.File;
import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceCompositeDescriptor;
import org.eclipse.cdt.codan.core.param.ListProblemPreference;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ParametersComposite
extends Composite {
    private static final String PREF_ENABLED = "enabled";
    private static final String PREF_SEVERITY = "severity";
    private static final String PREF_MESSAGE = "message";
    public static final String NO_CHANGE = CodanUIMessages.ParametersComposite_DoNotChange;
    private FieldEditorPreferencePage page;
    private IProblem problem;
    private PreferenceStore prefStore;
    private boolean combined;

    public ParametersComposite(Composite parent, final IProblem problem, final boolean combined) {
        super(parent, 0);
        if (problem == null) {
            throw new NullPointerException();
        }
        this.setLayout((Layout)new GridLayout(2, false));
        this.combined = combined;
        this.problem = problem;
        this.prefStore = new PreferenceStore();
        this.page = new FieldEditorPreferencePage(1){

            protected void createFieldEditors() {
                this.noDefaultAndApplyButton();
                ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 2;
                this.addField((FieldEditor)new BooleanFieldEditor(ParametersComposite.PREF_ENABLED, CodanUIMessages.ParametersComposite_IsEnabled, this.getFieldEditorParent()));
                String[][] entries = new String[][]{{CodanSeverity.Error.toTranslatableString(), CodanSeverity.Error.toString()}, {CodanSeverity.Warning.toTranslatableString(), CodanSeverity.Warning.toString()}, {CodanSeverity.Info.toTranslatableString(), CodanSeverity.Info.toString()}, {NO_CHANGE, NO_CHANGE}};
                this.addField((FieldEditor)new ComboFieldEditor(ParametersComposite.PREF_SEVERITY, CodanUIMessages.ParametersComposite_Severity, entries, this.getFieldEditorParent()));
                StringFieldEditor messagePatternEditor = new StringFieldEditor(ParametersComposite.PREF_MESSAGE, CodanUIMessages.ParametersComposite_MessagePattern, this.getFieldEditorParent());
                this.makeUneditable(messagePatternEditor);
                this.addField((FieldEditor)messagePatternEditor);
                IProblemPreference pref = problem.getPreference();
                this.createFieldEditorsForParameters(pref);
            }

            private void makeUneditable(StringFieldEditor editor) {
                Color background = editor.getLabelControl(this.getFieldEditorParent()).getBackground();
                Text text = editor.getTextControl(this.getFieldEditorParent());
                text.setBackground(background);
                text.setEditable(false);
            }

            protected Control createContents(Composite parent) {
                return super.createContents(parent);
            }

            private void createFieldEditorsForParameters(final IProblemPreference info) {
                if (info == null) {
                    return;
                }
                if (info.getKey() == "fileScope") {
                    return;
                }
                if (info.getKey() == "launchModes") {
                    return;
                }
                if (info.getKey() == "suppression_comment" && combined) {
                    return;
                }
                switch (info.getType()) {
                    case TYPE_STRING: {
                        StringFieldEditor fe = new StringFieldEditor(info.getQualifiedKey(), info.getLabel(), this.getFieldEditorParent());
                        this.addField((FieldEditor)fe);
                        break;
                    }
                    case TYPE_BOOLEAN: {
                        BooleanFieldEditor fe = new BooleanFieldEditor(info.getQualifiedKey(), info.getLabel(), this.getFieldEditorParent());
                        this.addField((FieldEditor)fe);
                        break;
                    }
                    case TYPE_LIST: {
                        ListEditor le = new ListEditor(info.getQualifiedKey(), info.getLabel(), this.getFieldEditorParent()){

                            protected String[] parseString(String stringList) {
                                ListProblemPreference list = (ListProblemPreference)info;
                                IProblemPreference[] childDescriptors = list.getChildDescriptors();
                                if (childDescriptors.length == 0) {
                                    return new String[0];
                                }
                                String[] res = new String[childDescriptors.length];
                                int i = 0;
                                while (i < childDescriptors.length) {
                                    IProblemPreference item = childDescriptors[i];
                                    res[i] = String.valueOf(item.getValue());
                                    ++i;
                                }
                                return res;
                            }

                            protected String getNewInputObject() {
                                ListProblemPreference list = (ListProblemPreference)info;
                                String label = list.getChildDescriptor().getLabel();
                                InputDialog dialog = new InputDialog(this.getShell(), CodanUIMessages.ParametersComposite_NewValue, label, "", null);
                                if (dialog.open() == 0) {
                                    return dialog.getValue();
                                }
                                return null;
                            }

                            protected String createList(String[] items) {
                                ListProblemPreference list = (ListProblemPreference)info.clone();
                                list.clear();
                                int i = 0;
                                while (i < items.length) {
                                    String val = items[i];
                                    list.addChildValue((Object)val);
                                    ++i;
                                }
                                return list.exportValue();
                            }
                        };
                        this.addField((FieldEditor)le);
                        break;
                    }
                    case TYPE_MAP: {
                        IProblemPreference[] childrenDescriptor = ((IProblemPreferenceCompositeDescriptor)info).getChildDescriptors();
                        int i = 0;
                        while (i < childrenDescriptor.length) {
                            IProblemPreference desc = childrenDescriptor[i];
                            this.createFieldEditorsForParameters(desc);
                            ++i;
                        }
                        break;
                    }
                    case TYPE_CUSTOM: {
                        StringFieldEditor fe = new StringFieldEditor(info.getQualifiedKey(), info.getLabel(), this.getFieldEditorParent());
                        this.addField((FieldEditor)fe);
                        break;
                    }
                    case TYPE_FILE: {
                        FileFieldEditor fe = new FileFieldEditor(info.getQualifiedKey(), info.getLabel(), this.getFieldEditorParent());
                        this.addField((FieldEditor)fe);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(info.getType().toString());
                    }
                }
            }
        };
        this.load(problem);
        this.page.setPreferenceStore((IPreferenceStore)this.prefStore);
        this.page.createControl(parent);
        this.page.getControl().setLayoutData((Object)new GridData(1808));
    }

    public void load(IProblem problem) {
        IProblemPreference info = problem.getPreference();
        if (info == null) {
            Label label = new Label((Composite)this, 0);
            label.setText(CodanUIMessages.ParametersComposite_None);
        } else {
            this.initPrefStore(info);
        }
        this.prefStore.setDefault(PREF_ENABLED, problem.isEnabled());
        if (problem.getMessagePattern() == NO_CHANGE) {
            this.prefStore.setDefault(PREF_SEVERITY, NO_CHANGE);
        } else {
            this.prefStore.setDefault(PREF_SEVERITY, problem.getSeverity().toString());
        }
        this.prefStore.setDefault(PREF_MESSAGE, problem.getMessagePattern());
    }

    public void save(IProblemWorkingCopy problem) {
        String message;
        this.page.performOk();
        this.savePrefStore(problem.getPreference());
        problem.setEnabled(this.prefStore.getBoolean(PREF_ENABLED));
        String severity = this.prefStore.getString(PREF_SEVERITY);
        if (!severity.equals(NO_CHANGE)) {
            problem.setSeverity(CodanSeverity.valueOf((String)severity));
        }
        if (!(message = this.prefStore.getString(PREF_MESSAGE)).equals(NO_CHANGE)) {
            problem.setMessagePattern(message);
        }
    }

    private void savePrefStore(IProblemPreference desc) {
        if (desc == null) {
            return;
        }
        String key = desc.getQualifiedKey();
        if (!this.prefStore.contains(key) && this.combined) {
            return;
        }
        switch (desc.getType()) {
            case TYPE_STRING: {
                desc.setValue((Object)this.prefStore.getString(key));
                break;
            }
            case TYPE_BOOLEAN: {
                desc.setValue((Object)this.prefStore.getBoolean(key));
                break;
            }
            case TYPE_INTEGER: {
                desc.setValue((Object)this.prefStore.getInt(key));
                break;
            }
            case TYPE_FILE: {
                desc.setValue((Object)new File(this.prefStore.getString(key)));
                break;
            }
            case TYPE_LIST: {
                desc.importValue(this.prefStore.getString(key));
                break;
            }
            case TYPE_CUSTOM: {
                desc.importValue(this.prefStore.getString(key));
                break;
            }
            case TYPE_MAP: {
                IProblemPreference[] childrenDescriptor = ((IProblemPreferenceCompositeDescriptor)desc).getChildDescriptors();
                int i = 0;
                while (i < childrenDescriptor.length) {
                    IProblemPreference chi = childrenDescriptor[i];
                    this.savePrefStore(chi);
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(desc.getType().toString());
            }
        }
    }

    private void initPrefStore(IProblemPreference desc) {
        if (desc == null || desc.getValue() == null) {
            return;
        }
        String key = desc.getQualifiedKey();
        switch (desc.getType()) {
            case TYPE_STRING: {
                this.prefStore.setDefault(key, (String)desc.getValue());
                break;
            }
            case TYPE_BOOLEAN: {
                this.prefStore.setDefault(key, ((Boolean)desc.getValue()).booleanValue());
                break;
            }
            case TYPE_INTEGER: {
                this.prefStore.setDefault(key, ((Integer)desc.getValue()).intValue());
                break;
            }
            case TYPE_FILE: {
                this.prefStore.setDefault(key, ((File)desc.getValue()).getPath());
                break;
            }
            case TYPE_LIST: {
                this.prefStore.setDefault(key, desc.exportValue());
                break;
            }
            case TYPE_CUSTOM: {
                this.prefStore.setDefault(key, desc.exportValue());
                break;
            }
            case TYPE_MAP: {
                IProblemPreference[] childrenDescriptor = ((IProblemPreferenceCompositeDescriptor)desc).getChildDescriptors();
                int i = 0;
                while (i < childrenDescriptor.length) {
                    IProblemPreference chi = childrenDescriptor[i];
                    this.initPrefStore(chi);
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(desc.getType().toString());
            }
        }
    }

    public IProblem getProblem() {
        return this.problem;
    }
}

