/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.tap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.cdt.testsrunner.internal.tap.TAPTestsRunnerMessages;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProvider;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.eclipse.cdt.testsrunner.model.TestingException;

public class TAPTestsRunnerProvider
implements ITestsRunnerProvider {
    private final Pattern VERSION_PATTERN = Pattern.compile("^TAP version \\d+$", 2);
    private final Pattern PLAN_PATTERN = Pattern.compile("^1..(?<count>\\d+)(\\s*#\\s*(?<message>(?<skip>skip).*|.*))?$", 2);
    private final Pattern BAIL_OUT_PATTERN = Pattern.compile("^Bail out!(\\s*(?<message>.+))?$", 2);
    private final Pattern TEST_RESULT_PATTERN = Pattern.compile("^(?<not>not )?ok( (?<number>\\d+))?(\\s*(?<name>[^#]+))?(\\s*#\\s*(?<message>((?<skip>SKIP)|(?<todo>TODO)).*|.*))?", 2);
    private final Pattern GCC_DIAGNOSTIC_PATTERN = Pattern.compile("^(?<filename>[^:]+):((?<line>\\d+):)? (?<level>(error|warning|info)):\\s*(?<message>.*)");

    public String[] getAdditionalLaunchParameters(String[][] testPaths) throws TestingException {
        return new String[0];
    }

    private String getErrorText(String prefix, String description) {
        return MessageFormat.format(TAPTestsRunnerMessages.TAPTestsRunner_error_format, prefix, description);
    }

    /*
     * Unable to fully structure code
     */
    public void run(ITestModelUpdater modelUpdater, InputStream inputStream) throws TestingException {
        try {
            firstLine = true;
            hasPlan = false;
            plannedCount = -1;
            currentTestNumber = 1;
            output = new LinkedList<String>();
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                block29: {
                    block32: {
                        block33: {
                            block31: {
                                block30: {
                                    block28: {
                                        m = this.VERSION_PATTERN.matcher(line);
                                        if (!m.matches()) break block28;
                                        if (!firstLine) {
                                            throw new TestingException(this.getErrorText(TAPTestsRunnerMessages.TAPTestsRunner_tap_error_prefix, TAPTestsRunnerMessages.TAPTestsRunner_invalid_version_line));
                                        }
                                        break block29;
                                    }
                                    m = this.PLAN_PATTERN.matcher(line);
                                    if (!m.matches()) break block30;
                                    if (hasPlan) {
                                        throw new TestingException(this.getErrorText(TAPTestsRunnerMessages.TAPTestsRunner_tap_error_prefix, TAPTestsRunnerMessages.TAPTestsRunner_multiple_plans));
                                    }
                                    hasPlan = true;
                                    plannedCount = Integer.parseInt(m.group("count"));
                                    if (m.group("skip") != null) {
                                        message = m.group("message");
                                        while (currentTestNumber <= plannedCount) {
                                            modelUpdater.enterTestCase(Integer.toString(currentTestNumber));
                                            if (message != null) {
                                                modelUpdater.addTestMessage(null, 0, ITestMessage.Level.Message, message);
                                            }
                                            modelUpdater.setTestStatus(ITestItem.Status.Skipped);
                                            modelUpdater.exitTestCase();
                                            ++currentTestNumber;
                                        }
                                        break;
                                    }
                                    break block29;
                                }
                                m = this.BAIL_OUT_PATTERN.matcher(line);
                                if (!m.matches()) break block31;
                                message = m.group("message");
                                while (currentTestNumber <= plannedCount) {
                                    modelUpdater.enterTestCase(Integer.toString(currentTestNumber));
                                    if (message != null) {
                                        modelUpdater.addTestMessage(null, 0, ITestMessage.Level.Message, message);
                                    }
                                    modelUpdater.setTestStatus(ITestItem.Status.Aborted);
                                    modelUpdater.exitTestCase();
                                    ++currentTestNumber;
                                }
                                break block29;
                            }
                            m = this.TEST_RESULT_PATTERN.matcher(line);
                            if (!m.matches()) break block32;
                            number = m.group("number");
                            if (number == null) break block33;
                            newNumber = Integer.parseInt(number);
                            if (newNumber >= currentTestNumber) ** GOTO lbl58
                            throw new TestingException(this.getErrorText(TAPTestsRunnerMessages.TAPTestsRunner_tap_error_prefix, TAPTestsRunnerMessages.TAPTestsRunner_invalid_test_number));
lbl-1000:
                            // 1 sources

                            {
                                modelUpdater.enterTestCase(Integer.toString(currentTestNumber));
                                modelUpdater.setTestStatus(ITestItem.Status.Skipped);
                                modelUpdater.exitTestCase();
                                ++currentTestNumber;
lbl58:
                                // 2 sources

                                ** while (currentTestNumber < newNumber)
                            }
lbl59:
                            // 1 sources

                            if (!TAPTestsRunnerProvider.$assertionsDisabled && currentTestNumber != newNumber) {
                                throw new AssertionError();
                            }
                        }
                        name = (name = m.group("name")) == null || name.trim().isEmpty() != false ? Integer.toString(currentTestNumber) : name.trim();
                        modelUpdater.enterTestCase(name);
                        message = m.group("message");
                        if (message != null) {
                            modelUpdater.addTestMessage(null, 0, ITestMessage.Level.Message, message);
                        }
                        for (String o : output) {
                            diagnosticMatch = this.GCC_DIAGNOSTIC_PATTERN.matcher(o);
                            if (diagnosticMatch.matches()) {
                                lineNumber = 0;
                                level = ITestMessage.Level.Message;
                                diagLine = diagnosticMatch.group("line");
                                if (diagLine != null) {
                                    lineNumber = Integer.parseInt(diagLine);
                                }
                                if ((diagLevel = diagnosticMatch.group("level")).equals("error")) {
                                    level = ITestMessage.Level.Error;
                                } else if (diagLevel.equals("warning")) {
                                    level = ITestMessage.Level.Warning;
                                } else if (diagLevel.equals("info")) {
                                    level = ITestMessage.Level.Info;
                                }
                                modelUpdater.addTestMessage(diagnosticMatch.group("filename"), lineNumber, level, diagnosticMatch.group("message"));
                                continue;
                            }
                            modelUpdater.addTestMessage(null, 0, ITestMessage.Level.Message, o);
                        }
                        output.clear();
                        if (m.group("skip") != null) {
                            modelUpdater.setTestStatus(ITestItem.Status.Skipped);
                        } else if (m.group("todo") != null) {
                            modelUpdater.setTestStatus(ITestItem.Status.NotRun);
                        } else if (m.group("not") != null) {
                            modelUpdater.setTestStatus(ITestItem.Status.Failed);
                        } else {
                            modelUpdater.setTestStatus(ITestItem.Status.Passed);
                        }
                        modelUpdater.exitTestCase();
                        ++currentTestNumber;
                        break block29;
                    }
                    output.add(line);
                }
                firstLine = false;
            }
            while (currentTestNumber <= plannedCount) {
                modelUpdater.enterTestCase(Integer.toString(currentTestNumber));
                modelUpdater.setTestStatus(ITestItem.Status.Skipped);
                modelUpdater.exitTestCase();
                ++currentTestNumber;
            }
        }
        catch (IOException e) {
            throw new TestingException(this.getErrorText(TAPTestsRunnerMessages.TAPTestsRunner_io_error_prefix, e.getLocalizedMessage()));
        }
    }
}

