/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;

public class ASTQueries {
    private static NameSearch NAME_SEARCH = new NameSearch();

    public static boolean canContainName(IASTNode node) {
        if (node == null) {
            return false;
        }
        NAME_SEARCH.reset();
        node.accept(NAME_SEARCH);
        return NAME_SEARCH.foundName();
    }

    public static IASTDeclarator findOutermostDeclarator(IASTDeclarator declarator) {
        IASTDeclarator outermost = null;
        IASTNode candidate = declarator;
        while (candidate instanceof IASTDeclarator) {
            outermost = candidate;
            candidate = outermost.getParent();
        }
        return outermost;
    }

    public static IASTDeclarator findInnermostDeclarator(IASTDeclarator declarator) {
        IASTDeclarator innermost = null;
        while (declarator != null) {
            innermost = declarator;
            declarator = declarator.getNestedDeclarator();
        }
        return innermost;
    }

    public static IASTDeclarator findTypeRelevantDeclarator(IASTDeclarator declarator) {
        if (declarator == null) {
            return null;
        }
        IASTDeclarator result = ASTQueries.findInnermostDeclarator(declarator);
        while (!(result.getPointerOperators().length != 0 || result instanceof IASTFieldDeclarator || result instanceof IASTFunctionDeclarator || result instanceof IASTArrayDeclarator)) {
            IASTNode parent = result.getParent();
            if (parent instanceof IASTDeclarator) {
                result = (IASTDeclarator)parent;
                continue;
            }
            return result;
        }
        return result;
    }

    public static <T extends IASTNode> T findAncestorWithType(IASTNode node, Class<T> type) {
        while (node != null && !type.isInstance(node)) {
            node = node.getParent();
        }
        return (T)node;
    }

    public static IBinding findEnclosingFunction(IASTNode node) {
        IASTName name;
        IASTFunctionDefinition functionDefinition = ASTQueries.findAncestorWithType(node, IASTFunctionDefinition.class);
        if (functionDefinition == null) {
            return null;
        }
        IASTDeclarator dtor = ASTQueries.findInnermostDeclarator(functionDefinition.getDeclarator());
        if (dtor != null && (name = dtor.getName()) != null) {
            return name.resolveBinding();
        }
        return null;
    }

    public static IASTDeclaration[] extractActiveDeclarations(IASTDeclaration[] allDeclarations, int size) {
        IASTDeclaration[] active;
        if (size == 0) {
            active = IASTDeclaration.EMPTY_DECLARATION_ARRAY;
        } else {
            active = new IASTDeclaration[size];
            int j = 0;
            int i = 0;
            while (i < size) {
                IASTDeclaration d = allDeclarations[i];
                if (d.isActive()) {
                    active[j++] = d;
                }
                ++i;
            }
            active = ArrayUtil.trim(active, j);
        }
        return active;
    }

    public static boolean isSameType(IType type1, IType type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.isSameType(type2);
    }

    protected static boolean areArraysOfTheSameElementType(IType t1, IType t2) {
        if (t1 instanceof IArrayType && t2 instanceof IArrayType) {
            IArrayType a1 = (IArrayType)t1;
            IArrayType a2 = (IArrayType)t2;
            return ASTQueries.isSameType(a1.getType(), a2.getType());
        }
        return false;
    }

    public static boolean isAncestorOf(IASTNode ancestor, IASTNode descendant) {
        do {
            if (descendant != ancestor) continue;
            return true;
        } while ((descendant = descendant.getParent()) != null);
        return false;
    }

    protected static boolean isLabelReference(IASTNode node) {
        boolean labelReference = false;
        IASTNode parent = node.getParent();
        if (parent instanceof IASTUnaryExpression) {
            int operator = ((IASTUnaryExpression)parent).getOperator();
            labelReference = operator == 18;
        }
        return labelReference;
    }

    protected static ILabel[] getLabels(IASTFunctionDefinition functionDefinition) {
        FindLabelsAction action = new FindLabelsAction();
        functionDefinition.accept(action);
        ILabel[] result = ILabel.EMPTY_ARRAY;
        if (action.labels != null) {
            int i = 0;
            while (i < action.labels.length && action.labels[i] != null) {
                IASTLabelStatement labelStatement = action.labels[i];
                IBinding binding = labelStatement.getName().resolveBinding();
                if (binding != null) {
                    result = ArrayUtil.append(result, (ILabel)binding);
                }
                ++i;
            }
        }
        return ArrayUtil.trim(result);
    }

    protected static IBinding resolveLabel(IASTName labelReference) {
        char[] labelName = labelReference.toCharArray();
        IASTFunctionDefinition functionDefinition = ASTQueries.findAncestorWithType(labelReference, IASTFunctionDefinition.class);
        if (functionDefinition != null) {
            ILabel[] iLabelArray = ASTQueries.getLabels(functionDefinition);
            int n = iLabelArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILabel label = iLabelArray[n2];
                if (CharArrayUtils.equals(label.getNameCharArray(), labelName)) {
                    return label;
                }
                ++n2;
            }
        }
        return new ProblemBinding((IASTNode)labelReference, 9, labelName);
    }

    private static class FindLabelsAction
    extends ASTVisitor {
        public IASTLabelStatement[] labels = IASTLabelStatement.EMPTY_ARRAY;

        public FindLabelsAction() {
            this.shouldVisitStatements = true;
        }

        @Override
        public int visit(IASTStatement statement) {
            if (statement instanceof IASTLabelStatement) {
                this.labels = ArrayUtil.append(this.labels, (IASTLabelStatement)statement);
            }
            return 3;
        }
    }

    private static class NameSearch
    extends ASTVisitor {
        private boolean fFound;

        NameSearch() {
            super(false);
            this.shouldVisitAmbiguousNodes = true;
            this.shouldVisitNames = true;
        }

        public void reset() {
            this.fFound = false;
        }

        public boolean foundName() {
            return this.fFound;
        }

        @Override
        public int visit(IASTName name) {
            this.fFound = true;
            return 2;
        }

        @Override
        public int visit(ASTAmbiguousNode node) {
            IASTNode[] alternatives;
            IASTNode[] iASTNodeArray = alternatives = node.getNodes();
            int n = alternatives.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode alt = iASTNodeArray[n2];
                if (!alt.accept(this)) {
                    return 2;
                }
                ++n2;
            }
            return 3;
        }
    }
}

