/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.team.ui;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.internal.team.ui.Messages;
import org.eclipse.mylyn.internal.team.ui.properties.TeamPropertiesLinkProvider;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TeamUiUtil {
    public static String getComment(boolean checkTaskRepository, ITask task, IResource[] resources) {
        String template = null;
        HashSet<IProject> projects = new HashSet<IProject>();
        if (resources != null) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Object resource = iResourceArray[n2];
                IProject project = resource.getProject();
                if (project != null && project.isAccessible() && !projects.contains(project)) {
                    TeamPropertiesLinkProvider provider = new TeamPropertiesLinkProvider();
                    template = provider.getCommitCommentTemplate((IResource)project);
                    if (template != null) break;
                    projects.add(project);
                }
                ++n2;
            }
        }
        boolean proceed = true;
        if (checkTaskRepository) {
            boolean unmatchedRepositoryFound = false;
            for (IProject project : projects) {
                TaskRepository repository = TasksUiPlugin.getDefault().getRepositoryForResource((IResource)project);
                if (repository == null || repository.getRepositoryUrl().equals(task.getRepositoryUrl())) continue;
                unmatchedRepositoryFound = true;
            }
            if (unmatchedRepositoryFound) {
                proceed = Display.getCurrent() != null ? MessageDialog.openQuestion((Shell)WorkbenchUtil.getShell(), (String)Messages.ContextChangeSet_Mylyn_Change_Set_Management, (String)Messages.ContextChangeSet_ATTEMPTING_TO_COMMIT_RESOURCE) : false;
            }
        }
        if (proceed) {
            if (template == null) {
                template = FocusedTeamUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.team.commit.template");
            }
            return FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment(task, template);
        }
        return "";
    }
}

