/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.core.auth;

import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;

public class UserCredentials
extends AuthenticationCredentials {
    private final String domain;
    private final String password;
    private final String userName;
    private final boolean savePassword;
    private final boolean hasSecrets;

    public UserCredentials(String userName, String password) {
        this(userName, password, null, true, true);
    }

    public UserCredentials(String userName, String password, boolean savePassword) {
        this(userName, password, null, savePassword, true);
    }

    public UserCredentials(String userName, String password, String domain, boolean savePassword) {
        this(userName, password, domain, savePassword, true);
    }

    public UserCredentials(String userName, String password, String domain, boolean savePassword, boolean hasSecrets) {
        Assert.isNotNull((Object)userName);
        Assert.isNotNull((Object)password);
        this.userName = userName;
        this.password = password;
        this.domain = domain;
        this.savePassword = savePassword;
        this.hasSecrets = hasSecrets;
    }

    protected UserCredentials(ICredentialsStore store, String prefix, boolean loadSecrets) throws StorageException {
        this(store.get(prefix + ".user", ""), loadSecrets ? store.get(prefix + ".password", "") : "", store.get(prefix + ".domain", null), store.getBoolean(prefix + ".savePassword", false), loadSecrets);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserCredentials other = (UserCredentials)obj;
        if (!Objects.equals(this.domain, other.domain)) {
            return false;
        }
        if (this.hasSecrets != other.hasSecrets) {
            return false;
        }
        if (!Objects.equals(this.password, other.password)) {
            return false;
        }
        if (this.savePassword != other.savePassword) {
            return false;
        }
        return Objects.equals(this.userName, other.userName);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.hasSecrets, this.password, this.savePassword, this.userName);
    }

    @Override
    public void clear(ICredentialsStore store, String prefix) {
        store.remove(prefix + ".user");
        store.remove(prefix + ".password");
        store.remove(prefix + ".domain");
        store.remove(prefix + ".savePassword");
    }

    @Override
    public void save(ICredentialsStore store, String prefix) {
        store.put(prefix + ".user", this.userName, false);
        if (this.hasSecrets) {
            store.put(prefix + ".password", this.password, true, this.savePassword);
        }
        store.put(prefix + ".domain", this.domain, false);
        store.putBoolean(prefix + ".savePassword", this.savePassword, false);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserCredentials [domain=");
        builder.append(this.domain);
        builder.append(", password=");
        builder.append(this.password == null ? this.password : "********");
        builder.append(", userName=");
        builder.append(this.userName);
        builder.append(", savePassword=");
        builder.append(this.savePassword);
        builder.append(", hasSecrets=");
        builder.append(this.hasSecrets);
        builder.append("]");
        return builder.toString();
    }
}

