/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation.dom;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.core.manipulation.dom.OperatorPrecedence;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

public class NecessaryParenthesesChecker {
    private static boolean expressionTypeNeedsParentheses(Expression expression) {
        int type = expression.getNodeType();
        return type == 27 || type == 16 || type == 38 || type == 37 || type == 11 || type == 62 || type == 104 || type == 3 || type == 7 || type == 100;
    }

    private static boolean needsParenthesesForSwitchExpression(Expression expression) {
        int type = expression.getNodeType();
        return type == 27 || type == 16 || type == 38 || type == 37 || type == 11 || type == 62 || type == 104 || type == 3 || type == 7 || type == 22 || type == 32;
    }

    private static boolean locationNeedsParentheses(StructuralPropertyDescriptor locationInParent) {
        if (locationInParent instanceof ChildListPropertyDescriptor && locationInParent != InfixExpression.EXTENDED_OPERANDS_PROPERTY) {
            return false;
        }
        return locationInParent != VariableDeclarationFragment.INITIALIZER_PROPERTY && locationInParent != SingleVariableDeclaration.INITIALIZER_PROPERTY && locationInParent != ReturnStatement.EXPRESSION_PROPERTY && locationInParent != EnhancedForStatement.EXPRESSION_PROPERTY && locationInParent != ForStatement.EXPRESSION_PROPERTY && locationInParent != WhileStatement.EXPRESSION_PROPERTY && locationInParent != DoStatement.EXPRESSION_PROPERTY && locationInParent != AssertStatement.EXPRESSION_PROPERTY && locationInParent != AssertStatement.MESSAGE_PROPERTY && locationInParent != IfStatement.EXPRESSION_PROPERTY && locationInParent != SwitchStatement.EXPRESSION_PROPERTY && locationInParent != SwitchCase.EXPRESSION_PROPERTY && locationInParent != SwitchCase.EXPRESSIONS2_PROPERTY && locationInParent != ArrayAccess.INDEX_PROPERTY && locationInParent != ThrowStatement.EXPRESSION_PROPERTY && locationInParent != SynchronizedStatement.EXPRESSION_PROPERTY && locationInParent != ParenthesizedExpression.EXPRESSION_PROPERTY;
    }

    private static boolean isAllOperandsHaveSameType(InfixExpression expression, ITypeBinding leftOperandType, ITypeBinding rightOperandType) {
        ITypeBinding binding = leftOperandType;
        if (binding == null) {
            return false;
        }
        ITypeBinding current = rightOperandType;
        if (binding != current) {
            return false;
        }
        for (Expression operand : expression.extendedOperands()) {
            current = operand.resolveTypeBinding();
            if (binding == current) continue;
            return false;
        }
        return true;
    }

    private static boolean isIntegerType(ITypeBinding binding) {
        if (binding == null) {
            return false;
        }
        if (!binding.isPrimitive()) {
            return false;
        }
        String name = binding.getName();
        return NecessaryParenthesesChecker.isIntegerNumber(name);
    }

    private static boolean isStringType(ITypeBinding binding) {
        if (binding == null) {
            return false;
        }
        return "java.lang.String".equals(binding.getQualifiedName());
    }

    private static boolean isAssociative(InfixExpression.Operator operator, ITypeBinding infixExprType, boolean isAllOperandsHaveSameType) {
        if (operator == InfixExpression.Operator.PLUS) {
            return NecessaryParenthesesChecker.isStringType(infixExprType) || NecessaryParenthesesChecker.isIntegerType(infixExprType) && isAllOperandsHaveSameType;
        }
        if (operator == InfixExpression.Operator.TIMES) {
            return NecessaryParenthesesChecker.isIntegerType(infixExprType) && isAllOperandsHaveSameType;
        }
        return operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR || operator == InfixExpression.Operator.AND || operator == InfixExpression.Operator.OR || operator == InfixExpression.Operator.XOR;
    }

    private static boolean isIntegerNumber(String name) {
        return "int".equals(name) || "long".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name);
    }

    private static boolean needsParenthesesInInfixExpression(Expression expression, InfixExpression parentInfix, StructuralPropertyDescriptor locationInParent, ITypeBinding leftOperandType) {
        ITypeBinding parentInfixExprType;
        ITypeBinding rightOperandType;
        InfixExpression.Operator parentInfixOperator = parentInfix.getOperator();
        if (leftOperandType == null) {
            leftOperandType = parentInfix.getLeftOperand().resolveTypeBinding();
            rightOperandType = parentInfix.getRightOperand().resolveTypeBinding();
            parentInfixExprType = parentInfix.resolveTypeBinding();
        } else {
            rightOperandType = expression.resolveTypeBinding();
            parentInfixExprType = NecessaryParenthesesChecker.getInfixExpressionType(parentInfixOperator, leftOperandType, rightOperandType);
        }
        boolean isAllOperandsHaveSameType = NecessaryParenthesesChecker.isAllOperandsHaveSameType(parentInfix, leftOperandType, rightOperandType);
        if (locationInParent == InfixExpression.LEFT_OPERAND_PROPERTY) {
            return false;
        }
        if (NecessaryParenthesesChecker.isAssociative(parentInfixOperator, parentInfixExprType, isAllOperandsHaveSameType)) {
            if (expression instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)expression;
                InfixExpression.Operator operator = infixExpression.getOperator();
                if (NecessaryParenthesesChecker.isStringType(parentInfixExprType)) {
                    if (parentInfixOperator == InfixExpression.Operator.PLUS && operator == InfixExpression.Operator.PLUS && NecessaryParenthesesChecker.isStringType(infixExpression.resolveTypeBinding())) {
                        return !NecessaryParenthesesChecker.isStringType(infixExpression.getLeftOperand().resolveTypeBinding()) && !NecessaryParenthesesChecker.isStringType(leftOperandType);
                    }
                    return true;
                }
                if (parentInfixOperator != InfixExpression.Operator.TIMES) {
                    return false;
                }
                if (operator == InfixExpression.Operator.TIMES) {
                    return false;
                }
                return operator == InfixExpression.Operator.REMAINDER || operator == InfixExpression.Operator.DIVIDE;
            }
            return false;
        }
        return true;
    }

    private static ITypeBinding getInfixExpressionType(InfixExpression.Operator operator, ITypeBinding leftOperandType, ITypeBinding rightOperandType) {
        if (leftOperandType == rightOperandType) {
            return leftOperandType;
        }
        if (operator == InfixExpression.Operator.PLUS) {
            if (NecessaryParenthesesChecker.isStringType(leftOperandType)) {
                return leftOperandType;
            }
            if (NecessaryParenthesesChecker.isStringType(rightOperandType)) {
                return rightOperandType;
            }
        }
        return null;
    }

    public static boolean canRemoveParentheses(Expression expression) {
        return NecessaryParenthesesChecker.canRemoveParentheses(expression, expression.getParent(), expression.getLocationInParent());
    }

    public static boolean canRemoveParentheses(Expression expression, ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        if (!(expression instanceof ParenthesizedExpression)) {
            return false;
        }
        return !NecessaryParenthesesChecker.needsParentheses(ASTNodes.getUnparenthesedExpression(expression), parent, locationInParent);
    }

    public static boolean needsParenthesesForRightOperand(Expression rightOperand, InfixExpression infixExpression, ITypeBinding leftOperandType) {
        return NecessaryParenthesesChecker.needsParentheses(rightOperand, (ASTNode)infixExpression, (StructuralPropertyDescriptor)InfixExpression.RIGHT_OPERAND_PROPERTY, leftOperandType);
    }

    public static boolean needsParentheses(Expression expression, ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        return NecessaryParenthesesChecker.needsParentheses(expression, parent, locationInParent, null);
    }

    private static boolean needsParentheses(Expression expression, ASTNode parent, StructuralPropertyDescriptor locationInParent, ITypeBinding leftOperandType) {
        if (!NecessaryParenthesesChecker.expressionTypeNeedsParentheses(expression)) {
            return false;
        }
        if (!NecessaryParenthesesChecker.locationNeedsParentheses(locationInParent)) {
            return false;
        }
        if (parent instanceof Expression) {
            int parentPrecedence;
            Expression parentExpression = (Expression)parent;
            if (expression instanceof SwitchExpression) {
                return NecessaryParenthesesChecker.needsParenthesesForSwitchExpression(parentExpression);
            }
            if ((expression instanceof PrefixExpression || expression instanceof PostfixExpression) && locationInParent == MethodInvocation.EXPRESSION_PROPERTY) {
                return true;
            }
            if (expression instanceof PrefixExpression) {
                return NecessaryParenthesesChecker.needsParenthesesForPrefixExpression(parentExpression, ((PrefixExpression)expression).getOperator());
            }
            if (expression instanceof ArrayCreation) {
                return parentExpression instanceof ArrayAccess && ((ArrayCreation)expression).getInitializer() == null;
            }
            int expressionPrecedence = OperatorPrecedence.getExpressionPrecedence(expression);
            if (expressionPrecedence > (parentPrecedence = OperatorPrecedence.getExpressionPrecedence(parentExpression))) {
                return false;
            }
            if (expressionPrecedence < parentPrecedence) {
                return true;
            }
            if (parentExpression instanceof InfixExpression) {
                return NecessaryParenthesesChecker.needsParenthesesInInfixExpression(expression, (InfixExpression)parentExpression, locationInParent, leftOperandType);
            }
            return parentExpression instanceof ConditionalExpression && locationInParent == ConditionalExpression.EXPRESSION_PROPERTY;
        }
        return true;
    }

    private static boolean needsParenthesesForPrefixExpression(Expression parentExpression, PrefixExpression.Operator expressionOperator) {
        if (parentExpression instanceof PrefixExpression) {
            PrefixExpression.Operator parentOperator = ((PrefixExpression)parentExpression).getOperator();
            if (parentOperator == PrefixExpression.Operator.PLUS && (expressionOperator == PrefixExpression.Operator.PLUS || expressionOperator == PrefixExpression.Operator.INCREMENT)) {
                return true;
            }
            if (parentOperator == PrefixExpression.Operator.MINUS && (expressionOperator == PrefixExpression.Operator.MINUS || expressionOperator == PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
        } else if (parentExpression instanceof InfixExpression) {
            InfixExpression.Operator parentOperator = ((InfixExpression)parentExpression).getOperator();
            if (parentOperator == InfixExpression.Operator.PLUS && (expressionOperator == PrefixExpression.Operator.PLUS || expressionOperator == PrefixExpression.Operator.INCREMENT)) {
                return true;
            }
            if (parentOperator == InfixExpression.Operator.MINUS && (expressionOperator == PrefixExpression.Operator.MINUS || expressionOperator == PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
        } else if (parentExpression instanceof CastExpression) {
            CastExpression castExp = (CastExpression)parentExpression;
            Type type = castExp.getType();
            return type == null || !type.isPrimitiveType();
        }
        return false;
    }

    private NecessaryParenthesesChecker() {
    }
}

