/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit6.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.MethodOrdererContext;

public class FailuresFirstMethodOrderer
implements MethodOrderer {
    private List<String> failuresList = new ArrayList<String>();
    private final Comparator<MethodDescriptor> comparator = new Comparator<MethodDescriptor>(){

        @Override
        public int compare(MethodDescriptor d1, MethodDescriptor d2) {
            boolean d1HasFailures = this.hasFailures(d1);
            boolean d2HasFailures = this.hasFailures(d2);
            if (d1HasFailures) {
                return -1;
            }
            if (d2HasFailures) {
                return 1;
            }
            return 0;
        }

        private boolean hasFailures(MethodDescriptor d) {
            String methodId = d.getMethod().getName() + "(" + d.getMethod().getDeclaringClass().getName() + ")";
            return FailuresFirstMethodOrderer.this.failuresList.contains(methodId);
        }
    };

    public void orderMethods(MethodOrdererContext context) {
        Optional failureNamesParm = context.getConfigurationParameter("org.eclipse.jdt.junit6.runtime.failureNames");
        String failureNamesString = failureNamesParm.orElse(null);
        if (failureNamesString != null) {
            String[] failureNames = failureNamesString.split(";");
            this.failuresList = Arrays.asList(failureNames);
        }
        context.getMethodDescriptors().sort(this.comparator);
    }
}

