/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.datamodel;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.PlatformObject;

@Immutable
public abstract class AbstractDMContext
extends PlatformObject
implements IDMContext {
    private final DsfSession fSession;
    private final IDMContext[] fParents;

    public AbstractDMContext(DsfSession session, IDMContext[] parents) {
        this.fSession = session;
        this.fParents = parents;
        IDMContext[] iDMContextArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext parent = iDMContextArray[n2];
            assert (parent != null);
            ++n2;
        }
    }

    public AbstractDMContext(IDsfService service, IDMContext[] parents) {
        this(service.getSession(), parents);
    }

    public AbstractDMContext(String fSessionId, IDMContext[] parents) {
        this(DsfSession.getSession(fSessionId), parents);
    }

    protected boolean baseEquals(Object other) {
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        IDMContext otherCtx = (IDMContext)other;
        return this.getSessionId().equals(otherCtx.getSessionId()) && this.areParentsEqual(otherCtx.getParents());
    }

    private boolean areParentsEqual(IDMContext[] otherParents) {
        IDMContext[] parents = this.getParents();
        if (parents.length != otherParents.length) {
            return false;
        }
        int i = 0;
        while (i < parents.length) {
            if (!parents[i].equals(otherParents[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected int baseHashCode() {
        int parentsHash = 0;
        IDMContext[] iDMContextArray = this.getParents();
        int n = iDMContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext parent = iDMContextArray[n2];
            parentsHash += parent.hashCode();
            ++n2;
        }
        return this.getSessionId().hashCode() + parentsHash;
    }

    protected String baseToString() {
        StringBuilder retVal = new StringBuilder();
        IDMContext[] iDMContextArray = this.getParents();
        int n = iDMContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext parent = iDMContextArray[n2];
            retVal.append(parent);
            retVal.append(',');
            ++n2;
        }
        if (retVal.length() > 0) {
            retVal.deleteCharAt(retVal.length() - 1);
        }
        if (this.getParents().length > 1) {
            retVal.insert(0, '(');
            retVal.insert(retVal.length(), ')');
        }
        return retVal.toString();
    }

    @Override
    public String getSessionId() {
        return this.fSession.getId();
    }

    @Override
    public IDMContext[] getParents() {
        return this.fParents;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        Object retVal = this.fSession.getModelAdapter(adapterType);
        if (retVal == null) {
            retVal = super.getAdapter(adapterType);
        }
        return (T)retVal;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

