/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.text.MessageFormat;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;

public class UIExtensionTracker
extends ExtensionTracker {
    private Executor executor;
    private ILog log;

    public UIExtensionTracker(Executor executor, ILog log) {
        this.executor = executor;
        this.log = log;
    }

    protected void applyRemove(IExtensionChangeHandler handler, IExtension removedExtension, Object[] objects) {
        this.executor.execute(() -> {
            try {
                handler.removeExtension(removedExtension, objects);
            }
            catch (Exception e) {
                this.log(((Object)((Object)this)).getClass(), "doRemove", e);
            }
        });
    }

    protected void applyAdd(IExtensionChangeHandler handler, IExtension addedExtension) {
        this.executor.execute(() -> {
            try {
                handler.addExtension((IExtensionTracker)this, addedExtension);
            }
            catch (Exception e) {
                this.log(((Object)((Object)this)).getClass(), "doAdd", e);
            }
        });
    }

    private void log(Class<?> clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format("Exception in {0}.{1}: {2}", clazz.getName(), methodName, t);
        this.log.error(msg, t);
    }
}

