/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.core.tests.mixin;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinBuildVisitor;
import org.eclipse.dltk.tcl.internal.parser.TclSourceParser;

public class XOTclMixinTests
extends TestCase {
    public void testParseUtil001() throws Throwable {
        String content = "namespace eval c  {\n}\nnamespace eval a {\n\tnamespace eval b {\n\t\tproc c::d { } {\n\t\t}\n\t}\n}\n";
        String expected = "c : null\na : null\na{b : null\nc{d : null\n";
        this.checkMixin(content, expected);
    }

    public void testParseUtil002() throws Throwable {
        String content = "package require XOTcl\nnamespace import ::xotcl::*\nClass MyModule\n# Documentation 1\nMyModule instproc myInstanceProc { vars } {\n\tputs \"MyInstanceProc\"\n}\nMyModule create myModuleInstance\nmyModuleInstance myInstanceProc\n";
        String expected = "MyModule : null\nMyModule{myInstanceProc : null\nmyModuleInstance : null\n";
        this.checkMixin(content, expected);
    }

    private void checkMixin(String content, String expected) throws Exception {
        ModuleDeclaration module = this.parser(content);
        TestMixinRequestorCollector collector = new TestMixinRequestorCollector();
        TclMixinBuildVisitor visitor = new TclMixinBuildVisitor(module, null, false, (IMixinRequestor)collector);
        module.traverse((ASTVisitor)visitor);
        IMixinRequestor.ElementInfo[] info = collector.getInfo();
        String actual = this.infoToString(info);
        XOTclMixinTests.assertEquals((String)expected, (String)actual);
    }

    private String infoToString(IMixinRequestor.ElementInfo[] info) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < info.length) {
            buffer.append(info[i] + "\n");
            ++i;
        }
        return buffer.toString();
    }

    private ASTNode[] findNodeByName(ModuleDeclaration module, final String name) throws Exception {
        final ArrayList results = new ArrayList();
        module.traverse(new ASTVisitor(){

            public boolean endvisit(TypeDeclaration s) throws Exception {
                if (s.getName().equals(name)) {
                    return results.add(s);
                }
                return super.endvisit(s);
            }

            public boolean visit(MethodDeclaration s) throws Exception {
                if (s.getName().equals(name)) {
                    return results.add(s);
                }
                return super.visit(s);
            }
        });
        return results.toArray(new ASTNode[results.size()]);
    }

    private ModuleDeclaration parser(String content) {
        TclSourceParser parser = new TclSourceParser();
        ModuleDeclaration module = parser.parse("file".toCharArray(), content.toCharArray(), null);
        XOTclMixinTests.assertNotNull((Object)module);
        return module;
    }

    class TestMixinRequestorCollector
    implements IMixinRequestor {
        private List infos = new ArrayList();

        TestMixinRequestorCollector() {
        }

        public void reportElement(IMixinRequestor.ElementInfo info) {
            this.infos.add(info);
        }

        public IMixinRequestor.ElementInfo[] getInfo() {
            return this.infos.toArray(new IMixinRequestor.ElementInfo[this.infos.size()]);
        }
    }
}

