/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui.externalchecker;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.validators.internal.ui.ValidatorsUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ExternalCheckerGenericHyperlink
implements IHyperlink {
    private TextConsole fConsole;

    public ExternalCheckerGenericHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws CoreException {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            return line;
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected abstract String getFileName();

    protected abstract int getLineNumber();

    public void linkActivated() {
        block8: {
            try {
                String editorId;
                IEditorInput editorInput;
                Object sourceElement;
                int lineNumber;
                String fileName;
                try {
                    this.getLinkText();
                    fileName = this.getFileName();
                    lineNumber = this.getLineNumber();
                }
                catch (CoreException coreException) {
                    return;
                }
                if (lineNumber > 0) {
                    --lineNumber;
                }
                if ((sourceElement = this.getSourceModule(fileName)) == null || (editorInput = this.getEditorInput(sourceElement)) == null || (editorId = this.getEditorId(editorInput, sourceElement)) == null) break block8;
                IEditorPart editorPart = ValidatorsUI.getActivePage().openEditor(editorInput, editorId);
                if (editorPart instanceof ITextEditor && lineNumber >= 0) {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    provider.connect((Object)editorInput);
                    IDocument document = provider.getDocument((Object)editorInput);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {}
                    provider.disconnect((Object)editorInput);
                }
                return;
            }
            catch (CoreException coreException) {
                return;
            }
        }
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public IEditorInput getEditorInput(Object item) {
        try {
            return EditorUtility.getEditorInput((Object)item);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected Object getSourceModule(String fileName) throws CoreException {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        return f;
    }
}

