/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.core.NullValidatorOutput;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.eclipse.dltk.validators.internal.core.ValidatorUtils;

public class ValidatorBuilder
implements IScriptBuilder {
    private static final boolean DEBUG = false;
    private static final int WORK_EXTERNAL = 200;

    public IStatus buildModelElements(IScriptProject project, List elements, IProgressMonitor monitor, int buildType) {
        IValidator[] validators = ValidatorRuntime.getProjectValidators(project, ISourceModuleValidator.class, new ValidatorRuntime.AutomaticValidatorPredicate(project));
        int validatorWork = validators.length * 200;
        monitor.beginTask("", validatorWork);
        try {
            if (validators.length != 0) {
                IStatus status;
                IStatus iStatus = status = ValidatorRuntime.executeSourceModuleValidators(project, elements, (IValidatorOutput)new NullValidatorOutput(), validators, ValidatorUtils.subMonitorFor(monitor, validatorWork));
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public IStatus buildResources(IScriptProject project, List resources, IProgressMonitor monitor, int buildType) {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, resources.size());
        try {
            IStatus iStatus = ValidatorRuntime.executeAutomaticResourceValidators(project, resources, new NullValidatorOutput(), (IProgressMonitor)sub);
            return iStatus;
        }
        finally {
            sub.done();
        }
    }

    public void clean(IScriptProject project, IProgressMonitor monitor) {
        ValidatorRuntime.cleanAll(project, new ISourceModule[0], new IResource[]{project.getProject()}, monitor);
    }

    public void initialize(IScriptProject project) {
    }

    public void endBuild(IScriptProject project, IProgressMonitor monitor) {
    }

    public IScriptBuilder.DependencyResponse getDependencies(IScriptProject project, int buildType, Set localElements, Set externalElements, Set oldExternalFolders, Set externalFolders) {
        return null;
    }
}

