/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core.externalchecker;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.validators.core.AbstractValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerMarker;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerProblem;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerWildcardManager;
import org.eclipse.dltk.validators.internal.core.externalchecker.Messages;
import org.eclipse.dltk.validators.internal.core.externalchecker.Rule;
import org.eclipse.dltk.validators.internal.core.externalchecker.WildcardMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExternalChecker
extends AbstractValidator {
    private static final String EXTENSIONS = "scriptPattrn";
    private String arguments;
    private Map paths;
    boolean initialized = false;
    private static final String ARGUMENTS = "arguments";
    private static final String PATH_TAG = "path";
    private static final String ENVIRONMENT_ATTR = "environment";
    private static final String PATH_ATTR = "path";
    private List rules = new ArrayList();
    private String extensions;
    static /* synthetic */ Class class$0;

    public void setCommand(Map command) {
        this.paths = command;
    }

    public void setRules(Vector list) {
        this.rules.clear();
        int i = 0;
        while (i < list.size()) {
            this.rules.add(list.get(i));
            ++i;
        }
    }

    public Map getCommand() {
        return this.paths;
    }

    public ExternalCheckerProblem parseProblem(String problem) {
        List wlist = ExternalCheckerWildcardManager.loadCustomWildcards();
        int i = 0;
        while (i < this.rules.size()) {
            block4: {
                Rule rule = (Rule)this.rules.get(i);
                try {
                    WildcardMatcher wmatcher = new WildcardMatcher(wlist);
                    ExternalCheckerProblem cproblem = wmatcher.match(rule, problem);
                    if (cproblem != null) {
                        return cproblem;
                    }
                }
                catch (Exception x) {
                    if (!DLTKCore.DEBUG) break block4;
                    System.out.println(x.toString());
                }
            }
            ++i;
        }
        return null;
    }

    public ExternalChecker(String id, String name, IValidatorType type) {
        super(id, name, type);
        this.arguments = "%f";
        this.paths = this.newEmptyPath();
        this.extensions = "*";
    }

    private Map newEmptyPath() {
        HashMap<IEnvironment, String> paths = new HashMap<IEnvironment, String>();
        IEnvironment[] environments = EnvironmentManager.getEnvironments();
        int i = 0;
        while (i < environments.length) {
            paths.put(environments[i], "");
            ++i;
        }
        return paths;
    }

    protected ExternalChecker(String id, IValidatorType type) {
        super(id, null, type);
        this.arguments = "%f";
        this.paths = this.newEmptyPath();
    }

    protected ExternalChecker(String id, Element element, IValidatorType type) {
        super(id, null, type);
        this.loadInfo(element);
    }

    public void loadInfo(Element element) {
        if (this.initialized) {
            return;
        }
        super.loadFrom(element);
        this.initialized = true;
        this.paths = this.newEmptyPath();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element elementNode;
            Node item = childNodes.item(i);
            if (item.getNodeType() == 1 && (elementNode = (Element)item).getTagName().equalsIgnoreCase("path")) {
                String environment = elementNode.getAttribute(ENVIRONMENT_ATTR);
                String path = elementNode.getAttribute("path");
                IEnvironment env = EnvironmentManager.getEnvironmentById((String)environment);
                if (env != null) {
                    this.paths.put(env, path);
                }
            }
            ++i;
        }
        this.arguments = element.getAttribute(ARGUMENTS);
        this.extensions = element.getAttribute(EXTENSIONS);
        NodeList nodes = element.getChildNodes();
        this.rules.clear();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            if (nodes.item(i2).getNodeName() == "rule") {
                NamedNodeMap map = nodes.item(i2).getAttributes();
                String ruletext = map.getNamedItem("TEXT").getNodeValue();
                String ruletype = map.getNamedItem("TYPE").getNodeValue();
                Rule r = new Rule(ruletext, ruletype);
                this.rules.add(r);
            }
            ++i2;
        }
    }

    public void storeTo(Document doc, Element element) {
        super.storeTo(doc, element);
        element.setAttribute(ARGUMENTS, this.arguments);
        element.setAttribute(EXTENSIONS, this.extensions);
        int i = 0;
        while (i < this.rules.size()) {
            Element elem = doc.createElement("rule");
            elem.setAttribute("TEXT", ((Rule)this.rules.get(i)).getDescription());
            elem.setAttribute("TYPE", ((Rule)this.rules.get(i)).getType());
            element.appendChild(elem);
            ++i;
        }
        Iterator iterator = this.paths.keySet().iterator();
        while (iterator.hasNext()) {
            IEnvironment env = (IEnvironment)iterator.next();
            if (env == null) continue;
            Element elem = doc.createElement("path");
            elem.setAttribute(ENVIRONMENT_ATTR, env.getId());
            elem.setAttribute("path", (String)this.paths.get(env));
            element.appendChild(elem);
        }
    }

    protected static IMarker reportErrorProblem(IResource resource, ExternalCheckerProblem problem, int start, int end) throws CoreException {
        return ExternalCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription(), 2, 1);
    }

    protected static IMarker reportWarningProblem(IResource resource, ExternalCheckerProblem problem, int start, int end) throws CoreException {
        return ExternalCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription(), 1, 1);
    }

    public void setArguments(String arguments) {
        this.initialized = true;
        this.arguments = arguments;
    }

    public String getArguments() {
        return this.arguments;
    }

    public IStatus validate(IResource[] resources, OutputStream console, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus validate(ISourceModule[] modules, OutputStream console, IProgressMonitor monitor) {
        block7: {
            IStatus iStatus;
            block6: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(Messages.ExternalChecker_checkingWithExternalExecutable, modules.length);
                try {
                    int i = 0;
                    while (i < modules.length) {
                        if (monitor.isCanceled()) {
                            iStatus = Status.CANCEL_STATUS;
                            Object var5_6 = null;
                            break block6;
                        }
                        this.validate(modules[i], console);
                        monitor.worked(1);
                        ++i;
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return iStatus;
        }
        Object var5_8 = null;
        monitor.done();
        return Status.OK_STATUS;
    }

    public IStatus validate(ISourceModule module, OutputStream console) {
        block23: {
            IResource resource;
            block21: {
                String elementName = module.getElementName();
                String[] split = this.extensions.split(";");
                boolean found = false;
                int i = 0;
                while (i < split.length) {
                    if (elementName.endsWith(split[i]) || split[i].equals("*")) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (this.extensions.equals("")) {
                    found = true;
                }
                if (!found) {
                    return Status.OK_STATUS;
                }
                resource = module.getResource();
                if (resource == null) {
                    return new Status(4, "org.eclipse.dltk.validators.core", Messages.ExternalChecker_sourceModuleResourceIsNull);
                }
                try {
                    ExternalCheckerMarker.clearMarkers(resource);
                }
                catch (CoreException e2) {
                    if (!DLTKCore.DEBUG) break block21;
                    e2.printStackTrace();
                }
            }
            IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)module);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IExecutionEnvironment execEnvironment = (IExecutionEnvironment)environment.getAdapter((Class)clazz);
            ArrayList<String> lines = new ArrayList<String>();
            String com = (String)this.paths.get(environment);
            if (com == null || com.trim().length() == 0) {
                return Status.CANCEL_STATUS;
            }
            String args = this.processArguments(resource, environment);
            String[] sArgs = args.split("::");
            ArrayList<String> coms = new ArrayList<String>();
            coms.add(com);
            int i = 0;
            while (i < sArgs.length) {
                coms.add(sArgs[i]);
                ++i;
            }
            String[] extcom = coms.toArray(new String[coms.size()]);
            BufferedReader input = null;
            Process process = null;
            try {
                try {
                    process = execEnvironment.exec(extcom, null, null);
                }
                catch (Throwable e) {
                    if (DLTKCore.DEBUG) {
                        System.out.println(e.toString());
                    }
                    return Status.CANCEL_STATUS;
                }
                input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = input.readLine()) != null) {
                    if (console != null) {
                        console.write((String.valueOf(line) + "\n").getBytes());
                    }
                    lines.add(line);
                }
                String content = "";
                content = module.getSource();
                ExternalCheckerCodeModel model = new ExternalCheckerCodeModel(content);
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    String line1 = (String)iterator.next();
                    ExternalCheckerProblem problem = this.parseProblem(line1);
                    if (problem == null) continue;
                    int[] bounds = model.getBounds(problem.getLineNumber() - 1);
                    if (problem.getType().indexOf(Messages.ExternalChecker_error) != -1) {
                        ExternalChecker.reportErrorProblem(resource, problem, bounds[0], bounds[1]);
                        continue;
                    }
                    if (problem.getType().indexOf(Messages.ExternalChecker_warning) == -1) continue;
                    ExternalChecker.reportWarningProblem(resource, problem, bounds[0], bounds[1]);
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block23;
                System.out.println(e.toString());
            }
        }
        return Status.OK_STATUS;
    }

    public void setNewRule(Rule s) {
        this.rules.add(s);
    }

    public Rule getRule(int index) {
        if (index < this.rules.size()) {
            return (Rule)this.rules.get(index);
        }
        return null;
    }

    public int getNRules() {
        return this.rules.size();
    }

    private String processArguments(IResource resource, IEnvironment environment) {
        String path = null;
        if (resource.getLocation() != null) {
            path = resource.getLocation().makeAbsolute().toOSString();
        } else {
            URI uri = resource.getLocationURI();
            IFileHandle file = environment.getFile(uri);
            path = file.toOSString();
        }
        String user = this.replaceSequence(this.arguments.replaceAll("\t", "::").replaceAll(" ", "::"), 'f', path);
        return user;
    }

    private String replaceSequence(String from, char pattern, String value) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < from.length()) {
            char c = from.charAt(i);
            if (c == '%' && i < from.length() - 1 && from.charAt(i + 1) == pattern) {
                buffer.append(value);
                ++i;
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean isValidatorValid(IEnvironment environment) {
        String path = (String)this.paths.get(environment);
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        IFileHandle file = environment.getFile((IPath)new Path(path));
        return file.exists();
    }

    public void clean(ISourceModule[] modules) {
        int i = 0;
        while (i < modules.length) {
            this.clean(modules[i].getResource());
            ++i;
        }
    }

    public void clean(IResource[] resource) {
        int i = 0;
        while (i < resource.length) {
            block3: {
                try {
                    ExternalCheckerMarker.clearMarkers(resource[i]);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String scriptPattern) {
        this.extensions = scriptPattern;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private static class ExternalCheckerCodeModel {
        private String[] codeLines;
        private int[] codeLineLengths;

        public ExternalCheckerCodeModel(String code) {
            this.codeLines = code.split("\n");
            int count = this.codeLines.length;
            this.codeLineLengths = new int[count];
            int sum = 0;
            int i = 0;
            while (i < count) {
                this.codeLineLengths[i] = sum;
                sum += this.codeLines[i].length() + 1;
                ++i;
            }
        }

        public int[] getBounds(int lineNumber) {
            if (this.codeLines.length <= lineNumber) {
                int[] nArray = new int[2];
                nArray[1] = 1;
                return nArray;
            }
            String codeLine = this.codeLines[lineNumber];
            String trimmedCodeLine = codeLine.trim();
            int start = this.codeLineLengths[lineNumber] + codeLine.indexOf(trimmedCodeLine);
            int end = start + trimmedCodeLine.length();
            return new int[]{start, end};
        }
    }
}

