/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.corext.util.Messages;

class OverwriteHelper {
    private Object fDestination;
    private IFile[] fFiles = new IFile[0];
    private IFolder[] fFolders = new IFolder[0];
    private ISourceModule[] fCus = new ISourceModule[0];
    private IProjectFragment[] fRoots = new IProjectFragment[0];
    private IScriptFolder[] fScriptFolders = new IScriptFolder[0];

    OverwriteHelper() {
    }

    public void setFiles(IFile[] files) {
        Assert.isNotNull((Object)files);
        this.fFiles = files;
    }

    public void setFolders(IFolder[] folders) {
        Assert.isNotNull((Object)folders);
        this.fFolders = folders;
    }

    public void setCus(ISourceModule[] cus) {
        Assert.isNotNull((Object)cus);
        this.fCus = cus;
    }

    public void setProjectFragments(IProjectFragment[] roots) {
        Assert.isNotNull((Object)roots);
        this.fRoots = roots;
    }

    public void setPackages(IScriptFolder[] fragments) {
        Assert.isNotNull((Object)fragments);
        this.fScriptFolders = fragments;
    }

    public IFile[] getFilesWithoutUnconfirmedOnes() {
        return this.fFiles;
    }

    public IFolder[] getFoldersWithoutUnconfirmedOnes() {
        return this.fFolders;
    }

    public ISourceModule[] getCusWithoutUnconfirmedOnes() {
        return this.fCus;
    }

    public IProjectFragment[] getProjectFragmentsWithoutUnconfirmedOnes() {
        return this.fRoots;
    }

    public IScriptFolder[] getPackagesWithoutUnconfirmedOnes() {
        return this.fScriptFolders;
    }

    public void confirmOverwritting(IReorgQueries reorgQueries, IModelElement destination) {
        Assert.isNotNull((Object)destination);
        this.fDestination = destination;
        this.confirmOverwritting(reorgQueries);
    }

    public void confirmOverwritting(IReorgQueries reorgQueries, IResource destination) {
        Assert.isNotNull((Object)destination);
        Assert.isNotNull((Object)reorgQueries);
        this.fDestination = destination;
        this.confirmOverwritting(reorgQueries);
    }

    private void confirmOverwritting(IReorgQueries reorgQueries) {
        IConfirmQuery overwriteQuery = reorgQueries.createYesYesToAllNoNoToAllQuery(RefactoringCoreMessages.OverwriteHelper_0, true, 6);
        IConfirmQuery skipQuery = reorgQueries.createSkipQuery(RefactoringCoreMessages.OverwriteHelper_2, 7);
        this.confirmFileOverwritting(overwriteQuery);
        this.confirmFolderOverwritting(skipQuery);
        this.confirmCuOverwritting(overwriteQuery);
        this.confirmProjectFragmentOverwritting(skipQuery);
        this.confirmPackageOverwritting(overwriteQuery);
    }

    private void confirmProjectFragmentOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IProjectFragment> toNotOverwrite = new ArrayList<IProjectFragment>(1);
        int i = 0;
        while (i < this.fRoots.length) {
            IProjectFragment root = this.fRoots[i];
            if (this.canOverwrite(root) && !OverwriteHelper.skip(root.getElementName(), overwriteQuery)) {
                toNotOverwrite.add(root);
            }
            ++i;
        }
        IProjectFragment[] roots = toNotOverwrite.toArray(new IProjectFragment[toNotOverwrite.size()]);
        this.fRoots = ArrayTypeConverter.toProjectFragmentArray(ReorgUtils.setMinus((IModelElement[])this.fRoots, (IModelElement[])roots));
    }

    private void confirmCuOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<ISourceModule> cusToNotOverwrite = new ArrayList<ISourceModule>(1);
        int i = 0;
        while (i < this.fCus.length) {
            ISourceModule cu = this.fCus[i];
            if (this.canOverwrite(cu) && !OverwriteHelper.overwrite((IModelElement)cu, overwriteQuery)) {
                cusToNotOverwrite.add(cu);
            }
            ++i;
        }
        ISourceModule[] cus = cusToNotOverwrite.toArray(new ISourceModule[cusToNotOverwrite.size()]);
        this.fCus = ArrayTypeConverter.toCuArray(ReorgUtils.setMinus((IModelElement[])this.fCus, (IModelElement[])cus));
    }

    private void confirmFolderOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IFolder> foldersToNotOverwrite = new ArrayList<IFolder>(1);
        int i = 0;
        while (i < this.fFolders.length) {
            IFolder folder = this.fFolders[i];
            if (this.canOverwrite((IResource)folder) && !OverwriteHelper.skip(folder.getName(), overwriteQuery)) {
                foldersToNotOverwrite.add(folder);
            }
            ++i;
        }
        IFolder[] folders = foldersToNotOverwrite.toArray(new IFolder[foldersToNotOverwrite.size()]);
        this.fFolders = ArrayTypeConverter.toFolderArray(ReorgUtils.setMinus((IResource[])this.fFolders, (IResource[])folders));
    }

    private void confirmFileOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IFile> filesToNotOverwrite = new ArrayList<IFile>(1);
        int i = 0;
        while (i < this.fFiles.length) {
            IFile file = this.fFiles[i];
            if (this.canOverwrite((IResource)file) && !OverwriteHelper.overwrite((IResource)file, overwriteQuery)) {
                filesToNotOverwrite.add(file);
            }
            ++i;
        }
        IFile[] files = filesToNotOverwrite.toArray(new IFile[filesToNotOverwrite.size()]);
        this.fFiles = ArrayTypeConverter.toFileArray(ReorgUtils.setMinus((IResource[])this.fFiles, (IResource[])files));
    }

    private void confirmPackageOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IScriptFolder> toNotOverwrite = new ArrayList<IScriptFolder>(1);
        int i = 0;
        while (i < this.fScriptFolders.length) {
            IScriptFolder pack = this.fScriptFolders[i];
            if (this.canOverwrite(pack) && !OverwriteHelper.overwrite((IModelElement)pack, overwriteQuery)) {
                toNotOverwrite.add(pack);
            }
            ++i;
        }
        IScriptFolder[] packages = toNotOverwrite.toArray(new IScriptFolder[toNotOverwrite.size()]);
        this.fScriptFolders = ArrayTypeConverter.toPackageArray(ReorgUtils.setMinus((IModelElement[])this.fScriptFolders, (IModelElement[])packages));
    }

    private boolean canOverwrite(IScriptFolder pack) {
        Assert.isTrue((boolean)(this.fDestination instanceof IProjectFragment));
        IProjectFragment destination = (IProjectFragment)this.fDestination;
        return !destination.equals(pack.getParent()) && destination.getScriptFolder(pack.getElementName()).exists();
    }

    private boolean canOverwrite(IResource resource) {
        if (resource == null) {
            return false;
        }
        IResource destinationResource = ResourceUtil.getResource(this.fDestination);
        if (destinationResource.equals((Object)resource.getParent())) {
            return false;
        }
        if (destinationResource instanceof IContainer) {
            IContainer container = (IContainer)destinationResource;
            IResource member = container.findMember(resource.getName());
            if (member == null || !member.exists()) {
                return false;
            }
            if (member instanceof IContainer) {
                try {
                    if (((IContainer)member).members().length == 0) {
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private boolean canOverwrite(IProjectFragment root) {
        Assert.isTrue((boolean)(this.fDestination instanceof IScriptProject));
        IScriptProject destination = (IScriptProject)this.fDestination;
        IFolder conflict = destination.getProject().getFolder(root.getElementName());
        try {
            return !destination.equals(root.getParent()) && conflict.exists() && conflict.members().length > 0;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    private boolean canOverwrite(ISourceModule cu) {
        if (this.fDestination instanceof IScriptFolder) {
            IScriptFolder destination = (IScriptFolder)this.fDestination;
            return !destination.equals(cu.getParent()) && destination.getSourceModule(cu.getElementName()).exists();
        }
        return this.canOverwrite(ReorgUtils.getResource((IModelElement)cu));
    }

    private static boolean overwrite(IResource resource, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(resource.getName(), overwriteQuery);
    }

    private static boolean overwrite(IModelElement element, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(element.getElementName(), overwriteQuery);
    }

    private static boolean overwrite(String name, IConfirmQuery overwriteQuery) {
        String question = Messages.format(RefactoringCoreMessages.OverwriteHelper_1, name);
        return overwriteQuery.confirm(question);
    }

    private static boolean skip(String name, IConfirmQuery overwriteQuery) {
        String question = Messages.format(RefactoringCoreMessages.OverwriteHelper_3, name);
        return overwriteQuery.confirm(question);
    }
}

