/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.wizards;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class TclProjectWizardFirstPage
extends ProjectWizardFirstPage {
    TclInterpreterGroup fInterpreterGroup;
    private Button useAnalysis;
    private Group packagesGroup;
    private Label labelElement;

    TclProjectWizardFirstPage() {
    }

    protected void createInterpreterGroup(Composite parent) {
        this.fInterpreterGroup = new TclInterpreterGroup(parent);
    }

    protected Observable getInterpreterGroupObservable() {
        return this.fInterpreterGroup;
    }

    protected boolean supportInterpreter() {
        return true;
    }

    protected IInterpreterInstall getInterpreter() {
        return this.fInterpreterGroup.getSelectedInterpreter();
    }

    protected void handlePossibleInterpreterChange() {
        this.fInterpreterGroup.handlePossibleInterpreterChange();
    }

    protected boolean interpeterRequired() {
        return false;
    }

    protected void createCustomGroups(Composite composite) {
        super.createCustomGroups(composite);
        this.packagesGroup = new Group(composite, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.packagesGroup.setLayoutData((Object)gridData);
        this.packagesGroup.setLayout((Layout)new GridLayout(1, false));
        this.packagesGroup.setText("Packages detector");
        this.useAnalysis = new Button((Composite)this.packagesGroup, 32);
        this.useAnalysis.setText("Detect packages from source code");
        this.useAnalysis.setSelection(true);
        this.labelElement = new Label((Composite)this.packagesGroup, 0);
        this.labelElement.setText("Enable package detection for Remote Projects could be realy slow...");
        Observer o = new Observer(){

            public void update(Observable o, Object arg) {
                boolean inWorkspace = TclProjectWizardFirstPage.this.fLocationGroup.isInWorkspace();
                TclProjectWizardFirstPage.this.packagesGroup.setEnabled(!inWorkspace);
                TclProjectWizardFirstPage.this.useAnalysis.setEnabled(!inWorkspace);
                TclProjectWizardFirstPage.this.labelElement.setEnabled(!inWorkspace);
            }
        };
        this.fLocationGroup.addObserver(o);
        this.fInterpreterGroup.addObserver(o);
    }

    public boolean useAnalysis() {
        final boolean[] result = new boolean[1];
        this.useAnalysis.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = TclProjectWizardFirstPage.this.useAnalysis.getSelection();
            }
        });
        return result[0];
    }

    final class TclInterpreterGroup
    extends ProjectWizardFirstPage.AbstractInterpreterGroup {
        public TclInterpreterGroup(Composite composite) {
            super((ProjectWizardFirstPage)TclProjectWizardFirstPage.this, composite);
        }

        protected String getCurrentLanguageNature() {
            return "org.eclipse.dltk.tcl.core.nature";
        }

        protected String getIntereprtersPreferencePageId() {
            return "org.eclipse.dltk.tcl.preferences.interpreters";
        }
    }
}

