/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclBuildPathPackageCollector
extends ASTVisitor {
    private final List<TclPackageDeclaration> requireDirectives = new ArrayList<TclPackageDeclaration>();
    private final Set<String> packagesRequired = new HashSet<String>();
    private final Set<String> packagesProvided = new HashSet<String>();

    public void process(ModuleDeclaration declaration) {
        try {
            declaration.traverse((ASTVisitor)this);
        }
        catch (Exception e) {
            TclPlugin.error(e);
        }
    }

    public boolean visit(Statement s) throws Exception {
        if (s instanceof TclPackageDeclaration) {
            TclPackageDeclaration pkg = (TclPackageDeclaration)s;
            if (pkg.getStyle() == 2) {
                if (TclPackagesManager.isValidName(pkg.getName())) {
                    this.requireDirectives.add(new TclPackageDeclaration(pkg));
                    this.packagesRequired.add(pkg.getName());
                }
            } else if (pkg.getStyle() == 1 || pkg.getStyle() == 0) {
                this.packagesProvided.add(pkg.getName());
            }
            return false;
        }
        return super.visit(s);
    }

    public List<TclPackageDeclaration> getRequireDirectives() {
        return this.requireDirectives;
    }

    public Set<String> getPackagesRequired() {
        return this.packagesRequired;
    }

    public Set<String> getPackagesProvided() {
        return this.packagesProvided;
    }
}

