/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;

public class TclParseUtils {
    public static final Object AST = "ast";

    public static List parseArguments(List st) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        if (st != null && st.size() > 0) {
            int y = 0;
            while (y < st.size()) {
                TclStatement tclSt;
                Object sty = st.get(y);
                if (sty instanceof FieldDeclaration) {
                    Argument a = new Argument();
                    a.set(((FieldDeclaration)sty).getRef(), null);
                    arguments.add(a);
                } else if (sty instanceof TclStatement && (tclSt = (TclStatement)((Object)sty)) instanceof TclStatement) {
                    Iterator i = tclSt.getExpressions().iterator();
                    while (i.hasNext()) {
                        Argument a;
                        String name;
                        TclBlockExpression bl;
                        List elements;
                        Expression ex = (Expression)i.next();
                        if (ex instanceof SimpleReference) {
                            Argument a2 = new Argument();
                            a2.set((SimpleReference)ex, null);
                            arguments.add(a2);
                            continue;
                        }
                        if (!(ex instanceof TclBlockExpression) || (elements = (bl = (TclBlockExpression)ex).parseBlockSimple()).size() <= 0) continue;
                        ASTNode node = (ASTNode)elements.get(0);
                        Expression initializer = null;
                        if (elements.size() > 1) {
                            initializer = (Expression)elements.get(1);
                        }
                        if (node instanceof TclStatement && ((TclStatement)node).getCount() > 0) {
                            TclStatement stat = (TclStatement)node;
                            node = stat.getAt(0);
                            if (stat.getCount() > 1) {
                                initializer = stat.getAt(1);
                            }
                        }
                        if (node instanceof SimpleReference) {
                            Argument a3 = new Argument();
                            a3.set((SimpleReference)node, null);
                            a3.setInitializationExpression((ASTNode)initializer);
                            arguments.add(a3);
                            continue;
                        }
                        if (node instanceof TclBlockExpression) {
                            name = ((TclBlockExpression)node).getBlock();
                            a = new Argument();
                            a.setStart(node.sourceStart() + 1);
                            a.setEnd(node.sourceEnd() + 1);
                            a.setArgumentName(TclParseUtils.nameFromBlock(name, '{', '}'));
                            a.setInitializationExpression((ASTNode)initializer);
                            arguments.add(a);
                            continue;
                        }
                        if (node instanceof StringLiteral) {
                            name = ((StringLiteral)node).getValue();
                            a = new Argument();
                            a.setStart(node.sourceStart() + 1);
                            a.setEnd(node.sourceEnd() + 1);
                            a.setArgumentName(TclParseUtils.nameFromBlock(name, '\"', '\"'));
                            a.setInitializationExpression((ASTNode)initializer);
                            arguments.add(a);
                            continue;
                        }
                        if (!(node instanceof TclExecuteExpression)) continue;
                        name = ((TclBlockExpression)node).getBlock();
                        a = new Argument();
                        a.setStart(node.sourceStart() + 1);
                        a.setEnd(node.sourceEnd() + 1);
                        a.setArgumentName(name);
                        a.setInitializationExpression((ASTNode)initializer);
                        arguments.add(a);
                    }
                }
                ++y;
            }
        }
        return arguments;
    }

    public static String nameFromBlock(String name, char c1, char c2) {
        if (name.charAt(0) == c1 || name.charAt(name.length() - 1) == c2) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }

    public static String[] returnVariable(TclStatement s) {
        Expression sName = s.getAt(0);
        ArrayList<Expression> variableName = new ArrayList<Expression>();
        if (!(sName instanceof SimpleReference)) {
            return null;
        }
        String name = ((SimpleReference)sName).getName();
        if (name.equals("set") && s.getCount() > 2) {
            variableName.add(s.getAt(1));
        } else if (name.equals("variable") && s.getCount() >= 2) {
            int j = 1;
            while (j < s.getCount()) {
                variableName.add(s.getAt(j));
                j += 2;
            }
        } else if (name.equals("global") && s.getCount() >= 2) {
            int j = 1;
            while (j < s.getCount()) {
                variableName.add(s.getAt(j));
                ++j;
            }
        } else if (name.equals("upvar")) {
            int i;
            Expression level = s.getAt(1);
            int startIndex = 1;
            if (level instanceof SimpleReference) {
                SimpleReference sLevel = (SimpleReference)level;
                String str = sLevel.getName();
                if (str == null || str.length() == 0) {
                    throw new RuntimeException("empty upvar level name");
                }
                if (str.startsWith("#") || Character.isDigit(str.charAt(0))) {
                    ++startIndex;
                }
            }
            if ((i = startIndex) < s.getCount()) {
                Expression vName = s.getAt(i + 1);
                if (vName == null) {
                    return null;
                }
                variableName.add(vName);
            }
        }
        if (variableName == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        int k = 0;
        while (k < variableName.size()) {
            if (variableName.get(k) instanceof SimpleReference) {
                name = ((SimpleReference)variableName.get(k)).getName();
                if (name.indexOf(40) != -1) {
                    name = name.substring(0, name.indexOf(40));
                }
            } else if (variableName.get(k) instanceof TclBlockExpression) {
                name = ((TclBlockExpression)((Object)variableName.get(k))).getBlock();
                name = TclParseUtils.nameFromBlock(name, '{', '}');
            } else if (variableName.get(k) instanceof StringLiteral) {
                name = ((StringLiteral)variableName.get(k)).getValue();
                name = TclParseUtils.nameFromBlock(name, '\"', '\"');
            } else {
                name = variableName.get(k) instanceof TclExecuteExpression ? ((TclExecuteExpression)((Object)variableName.get(k))).getExpression() : null;
            }
            if (name != null) {
                names.add(name);
            }
            ++k;
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static String returnVariableCheck(TclStatement s, int position) {
        Expression variableName;
        Expression sName = s.getAt(0);
        if (!(sName instanceof SimpleReference)) {
            return null;
        }
        String name = ((SimpleReference)sName).getName();
        if (name.equals("set") && s.getCount() > 2) {
            variableName = s.getAt(1);
        } else if (name.equals("variable") && s.getCount() >= 2) {
            variableName = s.getAt(1);
        } else if (name.equals("global") && s.getCount() >= 2) {
            variableName = s.getAt(1);
        } else if (name.equals("upvar") && s.getCount() >= 4) {
            variableName = s.getAt(3);
        } else {
            return null;
        }
        if (variableName.sourceStart() > position || position > variableName.sourceEnd()) {
            return null;
        }
        if (variableName instanceof SimpleReference) {
            name = ((SimpleReference)variableName).getName();
        } else if (variableName instanceof TclBlockExpression) {
            name = ((TclBlockExpression)variableName).getBlock();
            name = TclParseUtils.nameFromBlock(name, '{', '}');
        } else if (variableName instanceof StringLiteral) {
            name = ((StringLiteral)variableName).getValue();
            name = TclParseUtils.nameFromBlock(name, '\"', '\"');
        } else if (variableName instanceof TclExecuteExpression) {
            name = ((TclExecuteExpression)variableName).getExpression();
        } else {
            return null;
        }
        return name;
    }

    public static SimpleReference extractVariableFromString(StringLiteral literal, int pos) {
        String content = TclParseUtils.nameFromBlock(literal.getValue(), '\"', '\"');
        return TclParseUtils.extractVariableFromString(literal.sourceStart(), literal.sourceEnd(), pos, content);
    }

    public static SimpleReference extractVariableFromString(int start, int end, int pos, String content) {
        String sub;
        int position = pos - 1;
        int index = content.lastIndexOf(36, position);
        if (index != -1 && index < position && (sub = content.substring(index, position)).indexOf(32) == -1) {
            return new SimpleReference(start + index + 1, end + index + 1 + sub.length(), sub);
        }
        return null;
    }

    public static SimpleReference findVariableFromString(StringLiteral literal, int pos) {
        String content = TclParseUtils.nameFromBlock(literal.getValue(), '\"', '\"');
        int position = pos - 1;
        int start = TclParseUtils.startLineOrNoSymbol(position, content);
        if (position < 0) {
            position = 0;
        }
        try {
            if (content.charAt(position) == '$' && ++position < content.length() && content.charAt(position) == '{') {
                ++position;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        int end = TclParseUtils.endLineOrNoSymbol(position, content);
        if (start < 0) {
            start = 0;
        }
        if (start + 1 < content.length() && content.charAt(start) == '$' && content.charAt(start + 1) == '{' || start < content.length() && content.charAt(start) == '{') {
            while (content.charAt(end) != '}' && content.charAt(end) != '\\' && end < content.length()) {
                ++end;
            }
            ++end;
        }
        if (start < end) {
            String sub = content.substring(start, end);
            return new SimpleReference(literal.sourceStart() + start + 1, literal.sourceStart() + 1 + sub.length(), sub);
        }
        return null;
    }

    public static int endLineOrSymbol(int from, String content) {
        int pos = 0;
        pos = from;
        while (pos < content.length()) {
            char c = content.charAt(pos);
            if (c == '\n' || c == '\r' || c == ';') {
                return pos;
            }
            if (!Character.isWhitespace(c)) {
                return pos;
            }
            ++pos;
        }
        if (pos == content.length()) {
            return pos;
        }
        return from;
    }

    public static int startLineOrSymbol(int from, String content) {
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        int pos = from - 1;
        while (pos > 0) {
            char c = content.charAt(pos);
            if (c == '\n' || c == '\r' || c == ';') {
                return pos + 1;
            }
            if (!Character.isWhitespace(c)) {
                return pos + 1;
            }
            --pos;
        }
        return from;
    }

    public static int endLineOrNoSymbol(int from, String content) {
        int pos = 0;
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        pos = from;
        while (pos >= 0 && pos < content.length()) {
            if (TclParseUtils.checkBounds(content, pos) && (content.charAt(pos) != '$' || pos != from)) {
                return pos;
            }
            ++pos;
        }
        if (pos == content.length()) {
            return pos;
        }
        return pos;
    }

    private static boolean checkBounds(String content, int pos) {
        char[] syms = new char[]{' ', '\t', '\n', '\r', ']', '[', '}', '{', '(', ')', '$', '\\', ','};
        if (pos == -1) {
            pos = 1;
        }
        char c = content.charAt(pos);
        int i = 0;
        while (i < syms.length) {
            if (syms[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int startLineOrNoSymbol(int from, String content) {
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        int pos = from;
        while (pos >= 0 && pos < content.length()) {
            if (TclParseUtils.checkBounds(content, pos)) {
                if (content.charAt(pos) == '$') {
                    return pos;
                }
                return pos + 1;
            }
            --pos;
        }
        if (pos == -1) {
            return 0;
        }
        return pos;
    }

    public static String processMethodName(IMethod method, String tok) {
        String elName = method.getElementName();
        if (elName.startsWith("::")) {
            return TclParseUtils.checkDots(elName, tok);
        }
        String name = "";
        try {
            name = method.getTypeQualifiedName("$", false);
        }
        catch (ModelException e1) {
            e1.printStackTrace();
        }
        name = name.replaceAll("\\$", "::");
        if (tok.startsWith("::") && !name.startsWith("::")) {
            name = "::" + name;
        }
        return TclParseUtils.checkDots(name, tok);
    }

    public static String processFieldName(IField field, String tok) {
        String elName = field.getElementName();
        if (elName.startsWith("::")) {
            return TclParseUtils.checkDots(elName, tok);
        }
        String name = "";
        try {
            name = field.getTypeQualifiedName("$", false);
        }
        catch (ModelException e1) {
            e1.printStackTrace();
        }
        name = name.replaceAll("\\$", "::");
        if (tok.startsWith("::") && !name.startsWith("::")) {
            name = "::" + name;
        }
        return TclParseUtils.checkDots(name, tok);
    }

    private static String checkDots(String elName, String tok) {
        if (elName.startsWith("::") && !tok.startsWith("::")) {
            return elName.substring(2);
        }
        return elName;
    }

    public static String processTypeName(IType type, String tok) {
        String elName = type.getElementName();
        if (elName.startsWith("::")) {
            return elName;
        }
        String name = type.getTypeQualifiedName("$");
        name = name.replaceAll("\\$", "::");
        if (tok.startsWith("::") && !name.startsWith("::")) {
            name = "::" + name;
        }
        return name;
    }

    public static FieldDeclaration[] returnVariableDeclarations(TclStatement statement) {
        ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
        String[] vars = TclParseUtils.returnVariable(statement);
        if (vars != null) {
            int j = 0;
            while (j < vars.length) {
                int nStart = statement.sourceStart();
                int nEnd = statement.sourceEnd();
                List nodes = statement.getExpressions();
                int k = 0;
                while (k < nodes.size()) {
                    SimpleReference r;
                    Object o = nodes.get(k);
                    if (o instanceof SimpleReference && (r = (SimpleReference)o).getName().equals(vars[j])) {
                        nStart = r.sourceStart();
                        nEnd = r.sourceEnd();
                    }
                    ++k;
                }
                fields.add(new FieldDeclaration(vars[j], nStart, nEnd, nStart, nEnd));
                ++j;
            }
        }
        return fields.toArray(new FieldDeclaration[fields.size()]);
    }

    public static ModuleDeclaration parseModule(ISourceModuleInfoCache.ISourceModuleInfo astCache, char[] content, IProblemReporter problemReporter, char[] filename) {
        return SourceParserUtil.getModuleDeclaration((char[])filename, (char[])content, (String)"org.eclipse.dltk.tcl.core.nature", (IProblemReporter)problemReporter, (ISourceModuleInfoCache.ISourceModuleInfo)astCache, (int)0);
    }
}

