/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.search.mixin.model;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.ITclMixinElement;

public abstract class TclMixinElement
implements ITclMixinElement {
    private IMixinElement mixinElement = null;
    private ISourceModule sourceModule = null;
    private IModelElement modelElement = null;
    private TclMixinModel model = null;

    public abstract int getType();

    protected abstract boolean isValidModelElement(IModelElement var1);

    protected IModelElement findElement(ISourceModule module, String key) {
        String[] split = key.split("\\{");
        ISourceModule parent = module;
        int q = 0;
        if (split[0].equals("")) {
            q = 1;
        }
        int i = q;
        while (i < split.length) {
            block5: {
                try {
                    IModelElement[] children = parent.getChildren();
                    IModelElement e = this.findElementInChildren(split, (IParent)parent, i, children);
                    if (e != null) {
                        return e;
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    private IModelElement findElementInChildren(String[] split, IParent parent, int i, IModelElement[] children) {
        if (i >= split.length) {
            return null;
        }
        int j = 0;
        while (j < children.length) {
            if (children[j].getElementName().equals(split[i])) {
                IModelElement e = children[j];
                if (i == split.length - 1 && this.isValidModelElement(e)) {
                    return e;
                }
                if (e instanceof IParent) {
                    IModelElement e2;
                    block8: {
                        IParent pa = (IParent)e;
                        e2 = null;
                        try {
                            e2 = this.findElementInChildren(split, pa, i + 1, pa.getChildren());
                        }
                        catch (ModelException e1) {
                            if (!DLTKCore.DEBUG) break block8;
                            e1.printStackTrace();
                        }
                    }
                    if (e2 != null) {
                        return e2;
                    }
                }
            }
            ++j;
        }
        return null;
    }

    public void initialize(IMixinElement element, ISourceModule module, TclMixinModel model) {
        this.mixinElement = element;
        this.sourceModule = module;
        this.model = model;
    }

    public IModelElement getModelElement() {
        if (this.model != null && this.modelElement == null && this.mixinElement != null && this.sourceModule != null) {
            this.modelElement = this.findElement(this.sourceModule, this.mixinElement.getKey());
        }
        return this.modelElement;
    }

    public String getKey() {
        if (this.mixinElement != null) {
            return this.mixinElement.getKey();
        }
        return null;
    }

    public String getName() {
        IModelElement element = this.getModelElement();
        if (element != null) {
            return element.getElementName();
        }
        return null;
    }

    protected TclMixinModel getModel() {
        return this.model;
    }

    protected ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    protected IMixinElement getMixinElement() {
        return this.mixinElement;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mixinElement == null ? 0 : this.mixinElement.hashCode());
        result = 31 * result + (this.sourceModule == null ? 0 : this.sourceModule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TclMixinElement other = (TclMixinElement)obj;
        if (this.mixinElement == null ? other.mixinElement != null : !this.mixinElement.equals(other.mixinElement)) {
            return false;
        }
        return !(this.sourceModule == null ? other.sourceModule != null : !this.sourceModule.equals(other.sourceModule));
    }
}

