/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ast.IfStatement;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;

public class TclIfProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        List exprs = statement.getExpressions();
        int start = statement.sourceStart();
        int end = statement.sourceEnd();
        IfStatement ifStatement = new IfStatement(start, end);
        this.addToParent(parent, (ASTNode)ifStatement);
        ifStatement.acceptCondition(this.extractCondition(exprs, 1, parser));
        Block bl = new Block(ifStatement.sourceStart(), ifStatement.sourceEnd());
        ifStatement.acceptThen((Statement)bl);
        int currentPosition = 2;
        currentPosition = this.extractThen(exprs, currentPosition, parser, start, end, bl);
        if (statement.getCount() == 3) {
            return ifStatement;
        }
        List elseList = this.makeElseList(exprs, currentPosition, parser, start, end);
        Block el = new Block();
        ifStatement.acceptElse((ASTNode)el);
        ifStatement.acceptElse(this.extractElse(elseList, parser, start, end, el));
        return ifStatement;
    }

    private ASTNode extractElse(List exprs, ITclParser parser, int start, int end, Block el) {
        if (exprs.size() == 0) {
            return null;
        }
        if (exprs.size() == 1) {
            ASTNode node = (ASTNode)exprs.get(0);
            if (node instanceof TclBlockExpression) {
                TclBlockExpression block = (TclBlockExpression)node;
                this.parseBlock(parser, el, block);
                el.setStart(node.sourceStart());
                el.setEnd(node.sourceEnd());
                return el;
            }
            if (node instanceof SimpleReference) {
                el.addStatement(node);
            } else {
                if (node instanceof Statement) {
                    return node;
                }
                if (node instanceof TclExecuteExpression) {
                    return node;
                }
            }
            return null;
        }
        if (exprs.size() < 2) {
            this.report(parser, "Incorrect else", start, end, 1);
            return null;
        }
        ASTNode node = (ASTNode)exprs.get(0);
        if (!(node instanceof SimpleReference)) {
            this.report(parser, "Incorrect else block", start, end, 1);
            return null;
        }
        SimpleReference ref = (SimpleReference)node;
        if (ref.getName().equals("else")) {
            ASTNode nde = (ASTNode)exprs.get(1);
            if (nde instanceof TclBlockExpression) {
                TclBlockExpression block = (TclBlockExpression)nde;
                this.parseBlock(parser, el, block);
                el.setStart(nde.sourceStart());
                el.setEnd(nde.sourceEnd());
                return el;
            }
            this.report(parser, "Incorrect else block", ref.sourceStart(), ref.sourceEnd(), 1);
            return null;
        }
        if (ref.getName().equals("elseif")) {
            IfStatement ifStatement = new IfStatement(ref.sourceStart(), end);
            el.addStatement((ASTNode)ifStatement);
            ifStatement.acceptCondition(this.extractCondition(exprs, 1, parser));
            Block bl = new Block(start, end);
            ifStatement.acceptThen((Statement)bl);
            this.extractThen(exprs, 2, parser, start, end, bl);
            List elseList = this.makeElseList(exprs, 2, parser, start, end);
            Block el2 = new Block(start, end);
            ifStatement.acceptElse((ASTNode)el2);
            ifStatement.acceptElse(this.extractElse(elseList, parser, start, end, el2));
            return ifStatement;
        }
        return null;
    }

    private void parseBlock(ITclParser parser, Block el, TclBlockExpression block) {
        String blockContent = block.getBlock();
        blockContent = blockContent.substring(1, blockContent.length() - 1);
        parser.parse(blockContent, block.sourceStart() + 1 - parser.getStartPos(), (ASTNode)el);
    }

    private List makeElseList(List exprs, int i, ITclParser parser, int start, int end) {
        if (exprs.size() <= i) {
            this.report(parser, "Incorrect if statement", start, end, 1);
            return new ArrayList();
        }
        ASTNode node = (ASTNode)exprs.get(i);
        if (node instanceof SimpleReference && ((SimpleReference)node).getName().equals("then")) {
            if (exprs.size() >= i + 1) {
                this.report(parser, "Incorrect if statement", node, 1);
            }
            return exprs.subList(i + 2, exprs.size());
        }
        return exprs.subList(i + 1, exprs.size());
    }

    private int extractThen(List exprs, int i, ITclParser parser, int start, int end, Block bl) {
        if (exprs.size() <= i) {
            this.report(parser, "Incorrect if statement", start, end, 1);
            return 0;
        }
        ASTNode node = (ASTNode)exprs.get(i);
        if (node instanceof SimpleReference && ((SimpleReference)node).getName().equals("then")) {
            if (exprs.size() < i + 1) {
                this.report(parser, "Incorrect if statement", node, 1);
            }
            node = (ASTNode)exprs.get(++i);
        }
        if (node instanceof TclBlockExpression) {
            TclBlockExpression block = (TclBlockExpression)node;
            this.parseBlock(parser, bl, block);
            bl.setStart(node.sourceStart());
            bl.setEnd(node.sourceEnd());
            return i;
        }
        if (node instanceof TclStatement) {
            bl.addStatement(node);
            bl.setStart(node.sourceStart());
            bl.setEnd(node.sourceEnd());
            return i;
        }
        if (node instanceof TclExecuteExpression) {
            bl.addStatement(node);
            bl.setStart(node.sourceStart());
            bl.setEnd(node.sourceEnd());
            return i;
        }
        if (node instanceof SimpleReference) {
            ArrayList<ASTNode> es = new ArrayList<ASTNode>();
            es.add(node);
            TclStatement st = new TclStatement(es);
            st.setStart(node.sourceStart());
            st.setEnd(node.sourceEnd());
            bl.addStatement(node);
            bl.setStart(node.sourceStart());
            bl.setEnd(node.sourceEnd());
            return i;
        }
        this.report(parser, "Incorrect if then block", node, 1);
        return 0;
    }

    private ASTNode extractCondition(List exprs, int i, ITclParser parser) {
        if (exprs.size() <= i) {
            return null;
        }
        ASTNode node = (ASTNode)exprs.get(i);
        if (node instanceof TclBlockExpression) {
            TclBlockExpression bl = (TclBlockExpression)node;
            List parseBlock = bl.parseBlockSimple();
            ASTListNode list = new ASTListNode(bl.sourceStart() + 1, bl.sourceEnd() - 1);
            int j = 0;
            while (j < parseBlock.size()) {
                Object st = parseBlock.get(j);
                if (st instanceof TclStatement) {
                    List expressions = ((TclStatement)((Object)st)).getExpressions();
                    int k = 0;
                    while (k < expressions.size()) {
                        ASTNode expr = (ASTNode)expressions.get(k);
                        list.addNode(expr);
                        ++k;
                    }
                }
                ++j;
            }
            return list;
        }
        if (node instanceof SimpleReference) {
            return (Statement)node;
        }
        if (node instanceof TclAdvancedExecuteExpression) {
            TclAdvancedExecuteExpression ex = (TclAdvancedExecuteExpression)node;
            List childs = ex.getChilds();
            return new ASTListNode(node.sourceStart(), node.sourceEnd(), childs);
        }
        if (node instanceof TclExecuteExpression) {
            return node;
        }
        this.report(parser, "Incorrect if condition", node, 1);
        return null;
    }
}

