/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.debug.ui.preferences.ExternalDebuggingEngineOptionsBlock;
import org.eclipse.dltk.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.dltk.tcl.activestatedebugger.ErrorAction;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationFeature;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationPatternList;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PatternListIO;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.TclActiveStateDebuggerEnvironment;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.TclActiveStateDebuggerPreferencePage;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.TclLoggingPathBlock;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.TclSpawnpointPreferenceBlock;
import org.eclipse.dltk.ui.environment.EnvironmentPathBlock;
import org.eclipse.dltk.ui.preferences.IPreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.ui.preferences.PreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclActiveStateDebuggerBlock
extends ExternalDebuggingEngineOptionsBlock {
    private EnvironmentPathBlock pdxPath;
    private TclSpawnpointPreferenceBlock spawnpointBlock;
    private List<Button> instrumentationButtons;
    private Combo errorActionCombo;
    private InstrumentationPatternList patterns;
    private static final String FEATURE_KEY = String.valueOf(TclActiveStateDebuggerPreferencePage.class.getName()) + "#FEATURE";
    private TclLoggingPathBlock loggingBlock;

    public TclActiveStateDebuggerBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
    }

    protected Control createOptionsBlock(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        TabItem pathTab = new TabItem(tabFolder, 0);
        pathTab.setText(PreferenceMessages.path_tab);
        pathTab.setControl(super.createOptionsBlock((Composite)tabFolder));
        TabItem instrTab = new TabItem(tabFolder, 0);
        instrTab.setText(PreferenceMessages.instrumentation_tab);
        instrTab.setControl(this.createInstrumentationPage((Composite)tabFolder));
        TabItem spawnpointTab = new TabItem(tabFolder, 0);
        spawnpointTab.setText(PreferenceMessages.spawnpoints_tab);
        this.spawnpointBlock = new TclSpawnpointPreferenceBlock(new IShellProvider(){

            public Shell getShell() {
                return TclActiveStateDebuggerBlock.this.getShell();
            }
        }, (IPreferenceDelegate)this);
        spawnpointTab.setControl(this.spawnpointBlock.createControl((Composite)tabFolder));
        return tabFolder;
    }

    public static String[] createErrorActionItems() {
        ErrorAction[] errorActions = ErrorAction.values();
        String[] names = new String[errorActions.length + 1];
        names[0] = PreferenceMessages.instrumentation_errorAction_default_caption;
        int i = 0;
        while (i < errorActions.length) {
            names[i + 1] = errorActions[i].getCaption();
            ++i;
        }
        return names;
    }

    private Control createInstrumentationPage(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)4);
        Group groupPatterns = SWTFactory.createGroup((Composite)composite, (String)PreferenceMessages.instrumentation_patternsGroup, (int)1, (int)1, (int)1808);
        if (this.isProjectPreferencePage()) {
            this.patterns = new InstrumentationPatternList(this.getProject());
            this.patterns.createControl((Composite)groupPatterns);
        } else {
            Label label = new Label((Composite)groupPatterns, 0);
            label.setText(PreferenceMessages.TclActiveStateDebuggerBlock_patternsInProjectProperties);
            label.setEnabled(false);
            label.setLayoutData((Object)new GridData(768));
        }
        Group options = SWTFactory.createGroup((Composite)composite, (String)PreferenceMessages.instrumentation_options, (int)2, (int)1, (int)768);
        GridLayout optionsLayout = (GridLayout)options.getLayout();
        optionsLayout.marginHeight = 0;
        optionsLayout.makeColumnsEqualWidth = true;
        Composite compositeErrorAction = SWTFactory.createComposite((Composite)options, (Font)options.getFont(), (int)2, (int)2, (int)0);
        GridLayout errorActionLayout = (GridLayout)compositeErrorAction.getLayout();
        errorActionLayout.marginHeight = 0;
        errorActionLayout.marginWidth = 0;
        SWTFactory.createLabel((Composite)compositeErrorAction, (String)PreferenceMessages.instrumentation_errorAction_label, (int)1);
        this.errorActionCombo = SWTFactory.createCombo((Composite)compositeErrorAction, (int)8, (int)1, (String[])TclActiveStateDebuggerBlock.createErrorActionItems());
        ArrayList<InstrumentationFeature> left = new ArrayList<InstrumentationFeature>();
        left.add(InstrumentationFeature.DYNPROC);
        left.add(InstrumentationFeature.AUTOLOAD);
        ArrayList<InstrumentationFeature> right = new ArrayList<InstrumentationFeature>((Collection)Arrays.asList(InstrumentationFeature.values()));
        right.removeAll(left);
        this.instrumentationButtons = new ArrayList<Button>(left.size() + right.size());
        this.createButtons(this.instrumentationButtons, left, SWTFactory.createComposite((Composite)options, (Font)options.getFont(), (int)1, (int)1, (int)770));
        this.createButtons(this.instrumentationButtons, right, SWTFactory.createComposite((Composite)options, (Font)options.getFont(), (int)1, (int)1, (int)768));
        return composite;
    }

    private void createButtons(List<Button> buttons, List<InstrumentationFeature> features, Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
        layout.verticalSpacing = 2;
        layout.marginBottom = 5;
        layout.marginWidth = 0;
        for (InstrumentationFeature feature : features) {
            Button button = SWTFactory.createCheckButton((Composite)parent, (String)feature.getCaption());
            button.setData(FEATURE_KEY, (Object)feature);
            buttons.add(button);
        }
    }

    private void initValues() {
        if (this.patterns != null) {
            this.patterns.setValue(PatternListIO.decode(this.getString(TclActiveStateDebuggerPreferencePage.INSTRUMENTATION_PATTERNS)));
        }
        Set<InstrumentationFeature> result = InstrumentationFeature.decode(this.getString(TclActiveStateDebuggerPreferencePage.INSTRUMENTATION_FEATURES));
        for (Button button : this.instrumentationButtons) {
            InstrumentationFeature feature = (InstrumentationFeature)((Object)button.getData(FEATURE_KEY));
            button.setSelection(result.contains((Object)feature));
        }
        ErrorAction errorAction = ErrorAction.decode(this.getString(TclActiveStateDebuggerPreferencePage.INSTRUMENTATION_ERROR_ACTION));
        int errorActionIndex = errorAction == null ? 0 : Arrays.asList(ErrorAction.values()).indexOf((Object)errorAction) + 1;
        this.errorActionCombo.select(errorActionIndex);
        this.spawnpointBlock.initValues();
    }

    protected void initialize() {
        super.initialize();
        this.initValues();
    }

    public void performDefaults() {
        super.performDefaults();
        this.initValues();
    }

    protected void createEngineBlock(Composite parent) {
        super.createEngineBlock(parent);
        this.createPDXGroup(parent);
    }

    protected void createOtherBlock(Composite parent) {
        this.addDownloadLink(parent, PreferenceMessages.DebuggingEngineDownloadPage, PreferenceMessages.DebuggingEngineDownloadPageLink);
    }

    protected void createLoggingBlock(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)ScriptDebugPreferencesMessages.LoggingGroupLabel, (int)3, (int)1, (int)1808);
        this.loggingBlock = new TclLoggingPathBlock();
        this.loggingBlock.createControl((Composite)group, this.getRelevantEnvironments());
        Map paths = EnvironmentPathUtils.decodePaths((String)this.getString(this.getLogFileNamePreferenceKey()));
        this.loggingBlock.setPaths(paths);
        this.loggingBlock.setEnableLogging(TclActiveStateDebuggerEnvironment.decodeBooleans(this.getString(TclActiveStateDebuggerPreferencePage.LOG_ENABLE)));
    }

    protected void saveLoggingOptions() {
        String loggingPaths = EnvironmentPathUtils.encodePaths((Map)this.loggingBlock.getPaths());
        this.setString(this.getLogFileNamePreferenceKey(), loggingPaths);
        this.setString(TclActiveStateDebuggerPreferencePage.LOG_ENABLE, TclActiveStateDebuggerEnvironment.encodeBooleans(this.loggingBlock.getEnableLogging()));
    }

    private void createPDXGroup(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)PreferenceMessages.DebuggingEnginePDXGroup, (int)3, (int)1, (int)1808);
        this.pdxPath = new EnvironmentPathBlock(true);
        this.pdxPath.createControl((Composite)group, this.getRelevantEnvironments());
        Map paths = EnvironmentPathUtils.decodePaths((String)this.getString(TclActiveStateDebuggerPreferencePage.PDX_PATH));
        this.pdxPath.setPaths(paths);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        String pdxPathKeyValue = EnvironmentPathUtils.encodePaths((Map)this.pdxPath.getPaths());
        this.setString(TclActiveStateDebuggerPreferencePage.PDX_PATH, pdxPathKeyValue);
        if (this.patterns != null) {
            this.setString(TclActiveStateDebuggerPreferencePage.INSTRUMENTATION_PATTERNS, PatternListIO.encode(this.patterns.getValue()));
        }
        HashSet<InstrumentationFeature> selectedFeatures = new HashSet<InstrumentationFeature>();
        for (Button button : this.instrumentationButtons) {
            InstrumentationFeature feature = (InstrumentationFeature)((Object)button.getData(FEATURE_KEY));
            if (!button.getSelection()) continue;
            selectedFeatures.add(feature);
        }
        this.setString(TclActiveStateDebuggerPreferencePage.INSTRUMENTATION_FEATURES, InstrumentationFeature.encode(selectedFeatures));
        int errorActionIndex = this.errorActionCombo.getSelectionIndex();
        ErrorAction[] errorActions = ErrorAction.values();
        if (errorActionIndex > 0 && errorActionIndex <= errorActions.length) {
            this.setString(TclActiveStateDebuggerPreferencePage.INSTRUMENTATION_ERROR_ACTION, errorActions[errorActionIndex - 1].name());
        } else {
            this.setString(TclActiveStateDebuggerPreferencePage.INSTRUMENTATION_ERROR_ACTION, "");
        }
        return super.processChanges(container);
    }

    protected PreferenceKey getDebuggingEnginePathKey() {
        return TclActiveStateDebuggerPreferencePage.ENGINE_PATH;
    }

    protected PreferenceKey getLogFileNamePreferenceKey() {
        return TclActiveStateDebuggerPreferencePage.LOG_FILE_NAME;
    }

    protected IPreferenceChangeRebuildPrompt getPreferenceChangeRebuildPrompt(boolean workspaceSettings, Collection<PreferenceKey> changedOptions) {
        if (changedOptions.contains(TclActiveStateDebuggerPreferencePage.PREF_SPAWNPOINTS)) {
            return PreferenceChangeRebuildPrompt.create((boolean)workspaceSettings, (String)PreferenceMessages.TclActiveStateDebuggerBlock_rebuildTitle, (String)PreferenceMessages.TclActiveStateDebuggerBlock_rebuildMessage);
        }
        return null;
    }
}

