/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.editor;

import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ruby.internal.ui.text.RubyHeuristicScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPreferenceInterpreter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class RubyBracketInserter
extends BracketInserter {
    RubyBracketInserter(ScriptEditor scriptEditor) {
        super(scriptEditor);
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.editor.getInsertMode() != ITextEditorExtension3.SMART_INSERT) {
            return;
        }
        switch (event.character) {
            case '\n': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '(': 
            case '<': 
            case '[': {
                break;
            }
            default: {
                return;
            }
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selection = sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            String suffixString;
            String prefixString;
            int correctedOffset;
            ITypedRegion partition;
            IRegion startLine = document.getLineInformationOfOffset(offset);
            IRegion endLine = document.getLineInformationOfOffset(offset + length);
            RubyHeuristicScanner scanner = new RubyHeuristicScanner(document);
            int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
            String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
            int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
            int prevTokenOffset = scanner.getPosition();
            if (prevTokenOffset < 0) {
                prevTokenOffset = 0;
            }
            String previous = offset > 1 && prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            boolean hasPrefixContent = false;
            boolean hasSuffixContent = false;
            if (previous != null) {
                int hasOffset = startLine.getOffset();
                int hasLength = prevTokenOffset - startLine.getOffset();
                hasPrefixContent = hasLength > 0 && document.get(hasOffset, hasLength).trim().length() > 0;
                hasOffset = prevTokenOffset + previous.length() + 1;
                hasLength = startLine.getLength() - (hasOffset - startLine.getOffset());
                hasSuffixContent = hasLength > 0 && hasOffset + hasLength <= document.getLength() && document.get(hasOffset, hasLength).trim().length() > 0;
            }
            switch (event.character) {
                case '(': {
                    if (this.fCloseBrackets && nextToken != 5 && nextToken != 15 && (next == null || next.length() <= 1)) break;
                    return;
                }
                case '<': {
                    if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 12 && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 15 && this.isAngularIntroducer(previous) || prevToken == -1)) break;
                    return;
                }
                case '[': {
                    if (this.fCloseBrackets && nextToken != 15 && (next == null || next.length() <= 1)) break;
                    return;
                }
                case '\"': 
                case '\'': {
                    if (this.fCloseStrings && nextToken != 15 && (next == null || next.length() <= 1) && (previous == null || previous.length() <= 1 || previous.charAt(0) != event.character)) break;
                    return;
                }
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!("case".equals(previous) || "class".equals(previous) || "def".equals(previous) || "do".equals(previous) || "if".equals(previous) || "module".equals(previous) || "unless".equals(previous) || "while".equals(previous))) {
                        return;
                    }
                    if (hasPrefixContent && !"do".equals(previous) || hasSuffixContent) {
                        return;
                    }
                    if (prevTokenOffset + previous.length() >= offset - 1) break;
                    return;
                }
                default: {
                    return;
                }
            }
            if (!"__dftl_partition_content_type".equals((partition = TextUtilities.getPartition((IDocument)document, (String)"__ruby_partitioning", (int)(correctedOffset = document.getLength() > 0 && document.getLength() == offset ? offset - 1 : offset), (boolean)true)).getType())) {
                return;
            }
            if (!this.editor.validateEditorInputState()) {
                return;
            }
            char character = event.character;
            if (character == ' ' || character == '\r' || character == '\n') {
                String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                String prevIndent = this.getLineIndent(document, startLine);
                String nextIndent = this.selectIndent();
                if (character == '\r' || character == '\n') {
                    prefixString = String.valueOf(lineDelimiter) + prevIndent + nextIndent;
                    suffixString = String.valueOf(prevIndent) + "end";
                } else {
                    prefixString = "";
                    suffixString = String.valueOf(lineDelimiter) + prevIndent + nextIndent + lineDelimiter + prevIndent + "end";
                }
            } else {
                prefixString = "";
                suffixString = String.valueOf(RubyBracketInserter.getPeerCharacter((char)character));
            }
            char closingCharacter = suffixString.length() > 0 ? suffixString.charAt(0) : (char)'\u0000';
            document.replace(offset, length, String.valueOf(prefixString) + character + suffixString);
            ScriptEditor.BracketLevel level = new ScriptEditor.BracketLevel();
            this.fBracketLevelStack.push(level);
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addLinkingListener((ILinkedModeListener)this);
            model.addGroup(group);
            model.forceInstall();
            if (this.fBracketLevelStack.size() == 1) {
                document.addPositionCategory(this.CATEGORY);
                document.addPositionUpdater(this.fUpdater);
            }
            if (character == ' ' || character == '\r' || character == '\n') {
                level.fOffset = offset - previous.length();
                level.fLength = previous.length() + prefixString.length() + 1 + suffixString.length();
                level.fFirstPosition = new Position(offset - previous.length(), previous.length() + prefixString.length());
                level.fSecondPosition = new Position(offset + prefixString.length(), suffixString.length() + 1);
            } else {
                level.fOffset = offset;
                level.fLength = 2;
                level.fFirstPosition = new Position(offset, 1);
                level.fSecondPosition = new Position(offset + 1, 1);
            }
            document.addPosition(this.CATEGORY, level.fFirstPosition);
            document.addPosition(this.CATEGORY, level.fSecondPosition);
            level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
            level.fUI.setSimpleMode(true);
            LinkedModeUI linkedModeUI = level.fUI;
            ScriptEditor scriptEditor = this.editor;
            scriptEditor.getClass();
            linkedModeUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ScriptEditor.ExitPolicy(scriptEditor, closingCharacter, RubyBracketInserter.getEscapeCharacter((char)closingCharacter), this.fBracketLevelStack));
            level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
            level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            level.fUI.enter();
            IRegion newSelection = level.fUI.getSelectedRegion();
            if (character == ' ' || character == '\r' || character == '\n') {
                newSelection = new Region(newSelection.getOffset() + prefixString.length() - (character == '\r' || character == '\n' ? 1 : 0), newSelection.getLength());
            }
            sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
            event.doit = false;
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private String selectIndent() {
        return RubyPreferenceInterpreter.getDefault().getIndent();
    }

    private String getLineIndent(IDocument document, IRegion startLine) throws BadLocationException {
        int end = document.getLength();
        int cnt = startLine.getOffset();
        int max = document.getLength();
        while (cnt <= max) {
            if (!Character.isWhitespace(document.getChar(cnt))) {
                end = cnt;
                break;
            }
            ++cnt;
        }
        return document.get(startLine.getOffset(), end - startLine.getOffset());
    }
}

