/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.Serializable;

public final class Visibility
implements Serializable {
    private static final short PUBLIC_VALUE = 1;
    private static final short PROTECTED_VALUE = 2;
    private static final short PRIVATE_VALUE = 4;
    private static final short MODULE_FUNCTION_VALUE = 8;
    public static final Visibility PUBLIC = new Visibility(1);
    public static final Visibility PROTECTED = new Visibility(2);
    public static final Visibility PRIVATE = new Visibility(4);
    public static final Visibility MODULE_FUNCTION = new Visibility(8);
    public static final Visibility PUBLIC_PROTECTED = new Visibility(3);
    private final short restore;
    static final long serialVersionUID = 2002102900L;

    private Visibility(short restore) {
        this.restore = restore;
    }

    public boolean isPublic() {
        return (this.restore & 1) != 0;
    }

    public boolean isProtected() {
        return (this.restore & 2) != 0;
    }

    public boolean isPrivate() {
        return (this.restore & 4) != 0;
    }

    public boolean isModuleFunction() {
        return (this.restore & 8) != 0;
    }

    public boolean is(Visibility other) {
        return (this.restore & other.restore) != 0;
    }

    public String toString() {
        switch (this.restore) {
            case 1: {
                return "public";
            }
            case 2: {
                return "protected";
            }
            case 4: {
                return "private";
            }
            case 8: {
                return "module_function";
            }
        }
        return "mixed mask: " + this.restore;
    }
}

