/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.formatter.FormatterNodeRewriter;
import org.eclipse.dltk.formatter.FormatterUtils;
import org.eclipse.dltk.formatter.IFormatterCommentableNode;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterCommentNode;
import org.jruby.ast.CommentNode;
import org.jruby.parser.RubyParserResult;

public class RubyFormatterNodeRewriter
extends FormatterNodeRewriter {
    public RubyFormatterNodeRewriter(RubyParserResult result) {
        Iterator i = result.getCommentNodes().iterator();
        while (i.hasNext()) {
            CommentNode commentNode = (CommentNode)i.next();
            if (commentNode.isBlock()) continue;
            this.addComment(commentNode.getStartOffset(), commentNode.getEndOffset(), commentNode);
        }
    }

    public void rewrite(IFormatterContainerNode root) {
        this.mergeTextNodes(root);
        this.insertComments(root);
        this.attachComments(root);
    }

    private void attachComments(IFormatterContainerNode root) {
        IFormatterNode node;
        ArrayList commentNodes = new ArrayList();
        ArrayList<IFormatterNode> comments = new ArrayList<IFormatterNode>();
        List body = root.getBody();
        Iterator i = body.iterator();
        while (i.hasNext()) {
            node = (IFormatterNode)i.next();
            if (node instanceof FormatterCommentNode) {
                comments.add(node);
                continue;
            }
            if (FormatterUtils.isNewLine((IFormatterNode)node) && !comments.isEmpty() && comments.get(comments.size() - 1) instanceof FormatterCommentNode) {
                comments.add(node);
                continue;
            }
            if (comments.isEmpty()) continue;
            if (node instanceof IFormatterCommentableNode) {
                ((IFormatterCommentableNode)node).insertBefore(comments);
                commentNodes.addAll(comments);
            }
            comments.clear();
        }
        body.removeAll(commentNodes);
        i = body.iterator();
        while (i.hasNext()) {
            node = (IFormatterNode)i.next();
            if (!(node instanceof IFormatterContainerNode)) continue;
            this.attachComments((IFormatterContainerNode)node);
        }
    }

    protected IFormatterNode createCommentNode(IFormatterDocument document, int startOffset, int endOffset, Object object) {
        return new FormatterCommentNode(document, startOffset, endOffset);
    }
}

