/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.dltk.DLTKStructureBridge;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;

public class LandmarkMarkerManager
extends AbstractContextListener {
    private static final String MARKER_ID_LANDMARK = "org.eclipse.mylyn.ui.landmark";
    private Map markerMap = new HashMap();
    DLTKStructureBridge bridge = new DLTKStructureBridge();

    public void contextActivated(IInteractionContext taskscape) {
        this.modelUpdated();
    }

    public void contextDeactivated(IInteractionContext taskscape) {
        this.modelUpdated();
    }

    private void modelUpdated() {
        try {
            IInteractionElement node;
            Iterator<Object> it = this.markerMap.keySet().iterator();
            while (it.hasNext()) {
                node = (IInteractionElement)it.next();
                this.landmarkRemoved(node);
            }
            this.markerMap.clear();
            it = ContextCorePlugin.getContextManager().getActiveLandmarks().iterator();
            while (it.hasNext()) {
                node = (IInteractionElement)it.next();
                this.landmarkAdded(node);
            }
        }
        catch (Throwable t) {
            MylynStatusHandler.fail(t, "Could not update landmark markers", false);
        }
    }

    public void interestChanged(List nodes) {
    }

    public void landmarkAdded(final IInteractionElement node) {
        if (node == null || node.getContentType() == null) {
            return;
        }
        if (node.getContentType().equals(this.bridge.contentType)) {
            IModelElement element = DLTKCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return;
            }
            if (element instanceof IMember) {
                try {
                    final ISourceRange range = ((IMember)element).getNameRange();
                    final IResource resource = element.getUnderlyingResource();
                    if (resource instanceof IFile) {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                IMarker marker = resource.createMarker(LandmarkMarkerManager.MARKER_ID_LANDMARK);
                                if (marker != null && range != null) {
                                    marker.setAttribute("charStart", range.getOffset());
                                    marker.setAttribute("charEnd", range.getOffset() + range.getLength());
                                    marker.setAttribute("message", (Object)"Mylyn Landmark");
                                    marker.setAttribute("severity", 0);
                                    LandmarkMarkerManager.this.markerMap.put(node, new LongWrapper(marker.getId()));
                                }
                            }
                        };
                        resource.getWorkspace().run(runnable, null);
                    }
                }
                catch (ModelException e) {
                    MylynStatusHandler.fail(e, "couldn't update marker", false);
                }
                catch (CoreException e) {
                    MylynStatusHandler.fail(e, "couldn't update marker", false);
                }
            }
        }
    }

    public void landmarkRemoved(final IInteractionElement node) {
        if (node == null) {
            return;
        }
        if (node.getContentType().equals(this.bridge.contentType)) {
            IModelElement element = DLTKCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return;
            }
            if (element.getAncestor(5) != null && element instanceof ISourceReference) {
                try {
                    final IResource resource = element.getUnderlyingResource();
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            if (resource != null) {
                                try {
                                    long id;
                                    IMarker marker;
                                    if (LandmarkMarkerManager.this.markerMap.containsKey(node) && (marker = resource.getMarker(id = ((LongWrapper)LandmarkMarkerManager.this.markerMap.get(node)).value())) != null) {
                                        marker.delete();
                                    }
                                }
                                catch (NullPointerException e) {
                                    MylynStatusHandler.log(e, "could not update markers");
                                }
                            }
                        }
                    };
                    resource.getWorkspace().run(runnable, null);
                }
                catch (ModelException modelException) {
                }
                catch (CoreException e) {
                    MylynStatusHandler.fail(e, "couldn't update landmark marker", false);
                }
            }
        }
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void elementDeleted(IInteractionElement node) {
    }

    public void contextCleared(IInteractionContext arg0) {
    }

    private class LongWrapper {
        private long val = 0L;

        public LongWrapper(long v) {
            this.val = v;
        }

        public long value() {
            return this.val;
        }
    }
}

