/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.mylyn.internal.dltk.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.ui.IEditorPart;

public class ActiveFoldingEditorTracker
extends AbstractEditorTracker {
    protected Map editorListenerMap = new HashMap();

    public void editorOpened(IEditorPart part) {
        if (part instanceof ScriptEditor) {
            this.registerEditor((ScriptEditor)part);
        }
    }

    public void editorClosed(IEditorPart part) {
        if (part instanceof ScriptEditor) {
            this.unregisterEditor((ScriptEditor)part);
        }
    }

    public void registerEditor(ScriptEditor editor) {
        if (this.editorListenerMap.containsKey(editor)) {
            return;
        }
        ActiveFoldingListener listener = new ActiveFoldingListener(editor);
        this.editorListenerMap.put(editor, listener);
    }

    public void unregisterEditor(ScriptEditor editor) {
        ActiveFoldingListener listener = (ActiveFoldingListener)((Object)this.editorListenerMap.get(editor));
        if (listener != null) {
            listener.dispose();
        }
        this.editorListenerMap.remove(editor);
    }

    public Map getEditorListenerMap() {
        return this.editorListenerMap;
    }

    protected void editorBroughtToTop(IEditorPart part) {
    }
}

