/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.editor;

import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.FoldingActionGroup;
import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.javascript.core.JavaScriptLanguageToolkit;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.editor.JavaScriptBracketInserter;
import org.eclipse.dltk.javascript.internal.ui.editor.JavaScriptDocumentSetupParticipant;
import org.eclipse.dltk.javascript.internal.ui.editor.JavaScriptOutlinePage;
import org.eclipse.dltk.javascript.internal.ui.text.JavaScriptPairMatcher;
import org.eclipse.dltk.javascript.internal.ui.text.folding.JavascriptFoldingStructureProvider;
import org.eclipse.dltk.javascript.ui.actions.JavaScriptGenerateActionGroup;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class JavaScriptEditor
extends ScriptEditor {
    public static final String EDITOR_ID = "org.eclipse.dltk.javascript.ui.editor.JavascriptEditor";
    public static final String EDITOR_CONTEXT = "#JavascriptEditorContext";
    public static final String RULER_CONTEXT = "#JavascriptRulerContext";
    private BracketInserter fBracketInserter = new JavaScriptBracketInserter(this);
    private JavaScriptPairMatcher bracketMatcher = new JavaScriptPairMatcher("{}[]()".toCharArray());
    IFoldingStructureProvider fFoldingProvider = null;
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean(CLOSE_BRACKETS);
        boolean closeStrings = preferenceStore.getBoolean(CLOSE_STRINGS);
        boolean closeAngularBrackets = false;
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        this.fBracketInserter.setCloseAngularBracketsEnabled(closeAngularBrackets);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    protected IPreferenceStore getScriptPreferenceStore() {
        return JavaScriptUI.getDefault().getPreferenceStore();
    }

    public ScriptTextTools getTextTools() {
        return JavaScriptUI.getDefault().getTextTools();
    }

    protected ScriptOutlinePage doCreateOutlinePage() {
        return new JavaScriptOutlinePage(this, JavaScriptUI.getDefault().getPreferenceStore());
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("editor.matching_brackets", "editor.matching_brackets_color");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void connectPartitioningToElement(IEditorInput input, IDocument document) {
        IDocumentExtension3 extension;
        if (document instanceof IDocumentExtension3 && (extension = (IDocumentExtension3)document).getDocumentPartitioner("__javascript_partitioning") == null) {
            JavaScriptDocumentSetupParticipant participant = new JavaScriptDocumentSetupParticipant();
            participant.setup(document);
        }
    }

    protected IFoldingStructureProvider getFoldingStructureProvider() {
        if (this.fFoldingProvider == null) {
            this.fFoldingProvider = new JavascriptFoldingStructureProvider();
        }
        return this.fFoldingProvider;
    }

    protected FoldingActionGroup createFoldingActionGroup() {
        return new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer(), JavaScriptUI.getDefault().getPreferenceStore());
    }

    public String getEditorId() {
        return EDITOR_ID;
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        return JavaScriptLanguageToolkit.getDefault();
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.callhierarchy.view";
    }

    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        super.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            block7: {
                block6: {
                    String p;
                    block5: {
                        p = event.getProperty();
                        if (!CLOSE_BRACKETS.equals(p)) break block5;
                        this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(p));
                        break block6;
                    }
                    if (!CLOSE_STRINGS.equals(p)) break block7;
                    this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(p));
                }
                Object var3_3 = null;
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var3_5 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            super.handlePreferenceStoreChanged(event);
            throw throwable;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.dltk.ui.javascriptEditorScope"});
    }

    protected void createActions() {
        super.createActions();
        FormatElementAction action = new FormatElementAction();
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.quick.format");
        this.setAction("QuickFormat", (IAction)action);
        this.markAsStateDependentAction("QuickFormat", true);
        this.setAction("org.eclipse.dltk.ui.actions.FormatElement", (IAction)action);
        this.markAsStateDependentAction("org.eclipse.dltk.ui.actions.FormatElement", true);
        JavaScriptGenerateActionGroup generateActions = new JavaScriptGenerateActionGroup(this, "group.edit");
        this.fActionGroups.addGroup((ActionGroup)generateActions);
        this.fContextMenuGroup.addGroup((ActionGroup)generateActions);
    }

    protected class FormatElementAction
    extends Action
    implements IUpdate {
        FormatElementAction() {
            this.setText("Format Eleme&nt");
            this.setEnabled(JavaScriptEditor.this.isEditorInputModifiable());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ScriptSourceViewer viewer = (ScriptSourceViewer)JavaScriptEditor.this.getSourceViewer();
            if (!viewer.isEditable()) return;
            Point selection = viewer.rememberSelection();
            try {
                block9: {
                    try {
                        viewer.setRedraw(false);
                        String type = TextUtilities.getContentType((IDocument)viewer.getDocument(), (String)"__javascript_partitioning", (int)selection.x, (boolean)true);
                        if (type.equals("__dftl_partition_content_type") && selection.y == 0) {
                            try {
                                ISourceReference reference;
                                ISourceRange range;
                                int kind;
                                IModelElement element = JavaScriptEditor.this.getElementAt(selection.x, true);
                                if (element != null && element.exists() && ((kind = element.getElementType()) == 7 || kind == 9) && (range = (reference = (ISourceReference)element).getSourceRange()) != null) {
                                    viewer.setSelectedRange(range.getOffset(), range.getLength());
                                    viewer.doOperation(15);
                                }
                            }
                            catch (ModelException modelException) {}
                            break block9;
                        }
                        viewer.setSelectedRange(selection.x, 1);
                        viewer.doOperation(15);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                viewer.setRedraw(true);
                viewer.restoreSelection();
                throw throwable;
            }
            viewer.setRedraw(true);
            viewer.restoreSelection();
        }

        public void update() {
            this.setEnabled(JavaScriptEditor.this.isEditorInputModifiable());
        }
    }
}

